/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.util.Assert;

public class PersistentEntityResource
extends Resource<Object> {
    private static final Resources<EmbeddedWrapper> NO_EMBEDDEDS = new Resources(Collections.emptyList(), new Link[0]);
    private final PersistentEntity<?, ?> entity;
    private final Resources<EmbeddedWrapper> embeddeds;

    private PersistentEntityResource(PersistentEntity<?, ?> entity, Object content, Iterable<Link> links, Resources<EmbeddedWrapper> embeddeds) {
        super(content, links);
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        this.entity = entity;
        this.embeddeds = embeddeds == null ? NO_EMBEDDEDS : embeddeds;
    }

    public PersistentEntity<?, ? extends PersistentProperty<?>> getPersistentEntity() {
        return this.entity;
    }

    public PersistentPropertyAccessor getPropertyAccessor() {
        return this.entity.getPropertyAccessor(this.getContent());
    }

    @JsonUnwrapped
    public Resources<EmbeddedWrapper> getEmbeddeds() {
        return this.embeddeds;
    }

    public static Builder build(Object content, PersistentEntity<?, ?> entity) {
        return new Builder(content, entity);
    }

    public static class Builder {
        private final Object content;
        private final PersistentEntity<?, ?> entity;
        private final List<Link> links = new ArrayList<Link>();
        private Resources<EmbeddedWrapper> embeddeds;

        private Builder(Object content, PersistentEntity<?, ?> entity) {
            Assert.notNull((Object)content, (String)"Content must not be null!");
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            this.content = content;
            this.entity = entity;
        }

        public Builder withEmbedded(Iterable<EmbeddedWrapper> resources) {
            this.embeddeds = resources == null ? null : new Resources(resources, new Link[0]);
            return this;
        }

        public Builder withLink(Link link) {
            Assert.notNull((Object)link, (String)"Link must not be null!");
            this.links.add(link);
            return this;
        }

        public PersistentEntityResource build() {
            return new PersistentEntityResource(this.entity, this.content, this.links, this.embeddeds);
        }
    }
}

