/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.jedis.JedisClientUtils;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.connection.jedis.JedisScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisServerCommands;
import org.springframework.data.redis.connection.jedis.JedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisZSetCommands;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.util.Pool;

public class JedisConnection
extends AbstractRedisConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private final Jedis jedis;
    @Nullable
    private Transaction transaction;
    @Nullable
    private final Pool<Jedis> pool;
    private boolean broken = false;
    @Nullable
    private volatile JedisSubscription subscription;
    @Nullable
    private volatile Pipeline pipeline;
    private final int dbIndex;
    private final String clientName;
    private boolean convertPipelineAndTxResults = true;
    private List<JedisResult> pipelinedResults = new ArrayList<JedisResult>();
    private Queue<FutureResult<Response<?>>> txResults = new LinkedList();

    public JedisConnection(Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(Jedis jedis, Pool<Jedis> pool, int dbIndex) {
        this(jedis, pool, dbIndex, null);
    }

    protected JedisConnection(Jedis jedis, @Nullable Pool<Jedis> pool, int dbIndex, String clientName) {
        this.jedis = jedis;
        this.pool = pool;
        this.dbIndex = dbIndex;
        this.clientName = clientName;
        if ((long)dbIndex != jedis.getDB()) {
            try {
                this.select(dbIndex);
            }
            catch (DataAccessException ex) {
                this.close();
                throw ex;
            }
        }
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException exception;
        if (ex instanceof NullPointerException) {
            this.broken = true;
        }
        if ((exception = EXCEPTION_TRANSLATION.translate(ex)) instanceof RedisConnectionFailureException) {
            this.broken = true;
        }
        return exception != null ? exception : new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return new JedisKeyCommands(this);
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new JedisStringCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new JedisListCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new JedisSetCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new JedisZSetCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new JedisHashCommands(this);
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new JedisGeoCommands(this);
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return new JedisScriptingCommands(this);
    }

    @Override
    public RedisServerCommands serverCommands() {
        return new JedisServerCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new JedisHyperLogLogCommands(this);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"A valid command needs to be specified!");
        Assert.notNull((Object)args, (String)"Arguments must not be null!");
        try {
            Client client = JedisClientUtils.sendCommand(command, args, this.jedis);
            if (this.isQueueing() || this.isPipelined()) {
                Response<Object> result = JedisClientUtils.getResponse(this.isPipelined() ? this.getRequiredPipeline() : this.getRequiredTransaction());
                if (this.isPipelined()) {
                    this.pipeline(this.newJedisResult(result));
                } else {
                    this.transaction(this.newJedisResult(result));
                }
                return null;
            }
            return client.getOne();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        if (this.pool != null) {
            if (this.broken) {
                this.pool.returnBrokenResource((Object)this.jedis);
            } else {
                this.jedis.close();
            }
            return;
        }
        Exception exc = null;
        try {
            this.jedis.quit();
        }
        catch (Exception ex) {
            exc = ex;
        }
        try {
            this.jedis.disconnect();
        }
        catch (Exception ex) {
            exc = ex;
        }
        if (exc != null) {
            throw this.convertJedisAccessException(exc);
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        try {
            return !this.jedis.isConnected();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public boolean isQueueing() {
        return JedisClientUtils.isInMulti(this.jedis);
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.pipeline != null) {
            try {
                List<Object> list = this.convertPipelineResults();
                return list;
            }
            finally {
                this.pipeline = null;
                this.pipelinedResults.clear();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> convertPipelineResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        this.getRequiredPipeline().sync();
        DataAccessException cause = null;
        for (JedisResult result : this.pipelinedResults) {
            try {
                Object data = result.get();
                if (result.isStatus()) continue;
                results.add(result.conversionRequired() ? result.convert(data) : data);
            }
            catch (JedisDataException e) {
                DataAccessException dataAccessException = this.convertJedisAccessException((Exception)((Object)e));
                if (cause == null) {
                    cause = dataAccessException;
                }
                results.add((Object)dataAccessException);
            }
            catch (DataAccessException e) {
                if (cause == null) {
                    cause = e;
                }
                results.add((Object)e);
            }
        }
        if (cause != null) {
            throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)results);
        }
        return results;
    }

    void pipeline(JedisResult result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.pipelinedResults.add(result);
        }
    }

    void transaction(FutureResult<Response<?>> result) {
        this.txResults.add(result);
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newJedisResult(this.getRequiredPipeline().echo(message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newJedisResult(this.getRequiredTransaction().echo(message)));
                return null;
            }
            return this.jedis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newJedisResult(this.getRequiredPipeline().ping()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newJedisResult(this.getRequiredTransaction().ping()));
                return null;
            }
            return this.jedis.ping();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newStatusResult(this.getRequiredPipeline().discard()));
                return;
            }
            this.getRequiredTransaction().discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newJedisResult(this.getRequiredPipeline().exec(), new TransactionResultConverter(new LinkedList(this.txResults), JedisConverters.exceptionConverter())));
                List<Object> list = null;
                return list;
            }
            if (this.transaction == null) {
                throw new InvalidDataAccessApiUsageException("No ongoing transaction. Did you forget to call multi?");
            }
            List<Object> results = this.transaction.exec();
            List<Object> list = !CollectionUtils.isEmpty((Collection)results) ? new TransactionResultConverter(this.txResults, JedisConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Nullable
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline getRequiredPipeline() {
        Pipeline pipeline = this.getPipeline();
        if (pipeline == null) {
            throw new IllegalStateException("Connection has no active pipeline");
        }
        return pipeline;
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public Transaction getRequiredTransaction() {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Connection has no active transaction");
        }
        return transaction;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    JedisResult newJedisResult(Response<?> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).build();
    }

    <T, R> JedisResult newJedisResult(Response<T> response, Converter<T, R> converter) {
        return JedisResult.JedisResultBuilder.forResponse(response).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).build();
    }

    <T, R> JedisResult newJedisResult(Response<T> response, Converter<T, R> converter, Supplier<R> defaultValue) {
        return JedisResult.JedisResultBuilder.forResponse(response).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).mapNullTo(defaultValue).build();
    }

    JedisResult.JedisStatusResult newStatusResult(Response<?> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).buildStatusResult();
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.getRequiredPipeline().multi();
                return;
            }
            this.transaction = this.jedis.multi();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newStatusResult(this.getRequiredPipeline().select(dbIndex)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.newStatusResult(this.getRequiredTransaction().select(dbIndex)));
                return;
            }
            this.jedis.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            this.jedis.unwatch();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            for (byte[] key : keys) {
                if (this.isPipelined()) {
                    this.pipeline(this.newStatusResult(this.getRequiredPipeline().watch((byte[][])new byte[][]{key})));
                    continue;
                }
                this.jedis.watch((byte[][])new byte[][]{key});
            }
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newJedisResult(this.getRequiredPipeline().publish(channel, message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newJedisResult(this.getRequiredTransaction().publish(channel, message)));
                return null;
            }
            return this.jedis.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.jedis.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.jedis.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(RedisNode node) {
        Jedis temp = null;
        try {
            temp = this.getJedis(node);
            temp.connect();
            boolean bl = temp.ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (temp != null) {
                temp.disconnect();
                temp.close();
            }
        }
    }

    @Override
    protected JedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        return new JedisSentinelConnection(this.getJedis(sentinel));
    }

    protected Jedis getJedis(RedisNode node) {
        Jedis jedis = new Jedis(node.getHost(), node.getPort().intValue());
        if (StringUtils.hasText((String)this.clientName)) {
            jedis.clientSetname(this.clientName);
        }
        return jedis;
    }
}

