/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ClusterStateFailureException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterTopology;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClientUtils;
import org.springframework.data.redis.connection.jedis.JedisClusterGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterHashCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterListCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterServerCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterStringCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;

public class JedisClusterConnection
implements DefaultedRedisClusterConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private static final byte[][] EMPTY_2D_BYTE_ARRAY = new byte[0][];
    private final Log log = LogFactory.getLog(this.getClass());
    private final JedisCluster cluster;
    private boolean closed;
    private final JedisClusterTopologyProvider topologyProvider;
    private ClusterCommandExecutor clusterCommandExecutor;
    private final boolean disposeClusterCommandExecutorOnClose;
    @Nullable
    private volatile JedisSubscription subscription;

    public JedisClusterConnection(JedisCluster cluster) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null.");
        this.cluster = cluster;
        this.closed = false;
        this.topologyProvider = new JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new JedisClusterNodeResourceProvider(cluster, this.topologyProvider), EXCEPTION_TRANSLATION);
        this.disposeClusterCommandExecutorOnClose = true;
        try {
            DirectFieldAccessor dfa = new DirectFieldAccessor((Object)cluster);
            this.clusterCommandExecutor.setMaxRedirects((Integer)dfa.getPropertyValue("maxRedirections"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JedisClusterConnection(JedisCluster cluster, ClusterCommandExecutor executor) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null.");
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null.");
        this.closed = false;
        this.cluster = cluster;
        this.topologyProvider = new JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    @Override
    @Nullable
    public Object execute(String command, byte[] ... args) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        return this.clusterCommandExecutor.executeCommandOnArbitraryNode(client -> JedisClientUtils.execute(command, EMPTY_2D_BYTE_ARRAY, args, () -> client)).getValue();
    }

    @Override
    @Nullable
    public <T> T execute(String command, byte[] key, Collection<byte[]> args) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(args, (String)"Args must not be null!");
        byte[][] commandArgs = JedisClusterConnection.getCommandArguments(key, args);
        RedisClusterNode keyMaster = this.topologyProvider.getTopology().getKeyServingMasterNode(key);
        return this.clusterCommandExecutor.executeCommandOnSingleNode(client -> JedisClientUtils.execute(command, EMPTY_2D_BYTE_ARRAY, commandArgs, () -> client), keyMaster).getValue();
    }

    private static byte[][] getCommandArguments(byte[] key, Collection<byte[]> args) {
        byte[][] commandArgs = new byte[args.size() + 1][];
        commandArgs[0] = key;
        int targetIndex = 1;
        for (byte[] binaryArgument : args) {
            commandArgs[targetIndex++] = binaryArgument;
        }
        return commandArgs;
    }

    @Nullable
    public <T> List<T> execute(String command, Collection<byte[]> keys, Collection<byte[]> args) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        Assert.notNull(keys, (String)"Key must not be null!");
        Assert.notNull(args, (String)"Args must not be null!");
        return this.clusterCommandExecutor.executeMultiKeyCommand((client, key) -> JedisClientUtils.execute(command, new byte[][]{key}, (byte[][])args.toArray((T[])new byte[args.size()][]), () -> client), keys).resultsAsList();
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new JedisClusterGeoCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new JedisClusterHashCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new JedisClusterHyperLogLogCommands(this);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this.doGetKeyCommands();
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new JedisClusterStringCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new JedisClusterListCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new JedisClusterSetCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new JedisClusterZSetCommands(this);
    }

    @Override
    public RedisClusterServerCommands serverCommands() {
        return new JedisClusterServerCommands(this);
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return JedisClusterScriptingCommands.INSTANCE;
    }

    private JedisClusterKeyCommands doGetKeyCommands() {
        return new JedisClusterKeyCommands(this);
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return this.doGetKeyCommands().keys(node, pattern);
    }

    @Override
    public Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        return this.doGetKeyCommands().scan(node, options);
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return this.doGetKeyCommands().randomKey(node);
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MUTLI is currently not supported in cluster mode.");
    }

    @Override
    public List<Object> exec() {
        throw new InvalidDataAccessApiUsageException("EXEC is currently not supported in cluster mode.");
    }

    @Override
    public void discard() {
        throw new InvalidDataAccessApiUsageException("DISCARD is currently not supported in cluster mode.");
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode.");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode.");
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            return this.cluster.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.cluster.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.cluster.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        if (dbIndex != 0) {
            throw new InvalidDataAccessApiUsageException("Cannot SELECT non zero index in cluster mode.");
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            return this.cluster.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        return !this.clusterCommandExecutor.executeCommandOnAllNodes(BinaryJedis::ping).resultsAsList().isEmpty() ? "PONG" : null;
    }

    @Override
    public String ping(RedisClusterNode node) {
        return (String)this.clusterCommandExecutor.executeCommandOnSingleNode(BinaryJedis::ping, node).getValue();
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null.");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null.");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        String nodeId = nodeToUse.getId();
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> {
            switch (mode) {
                case IMPORTING: {
                    return client.clusterSetSlotImporting(slot, nodeId);
                }
                case MIGRATING: {
                    return client.clusterSetSlotMigrating(slot, nodeId);
                }
                case STABLE: {
                    return client.clusterSetSlotStable(slot);
                }
                case NODE: {
                    return client.clusterSetSlotNode(slot, nodeId);
                }
            }
            throw new IllegalArgumentException(String.format("Unknown AddSlots mode '%s'.", new Object[]{mode}));
        }, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> JedisConverters.stringListToByteList().convert(client.clusterGetKeysInSlot(slot, count != null ? count : Integer.MAX_VALUE)), node);
        return null;
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterAddSlots(slots), node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        return (Long)this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterCountKeysInSlot(slot), node).getValue();
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterDelSlots(slots), node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        LinkedHashSet<RedisClusterNode> nodes = new LinkedHashSet<RedisClusterNode>(this.topologyProvider.getTopology().getActiveMasterNodes());
        RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(client -> client.clusterForget(node.getId()), nodes);
    }

    @Override
    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        this.clusterCommandExecutor.executeCommandOnAllNodes(client -> client.clusterMeet(node.getHost(), node.getPort().intValue()));
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterReplicate(masterNode.getId()), slave);
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        return (Integer)this.clusterCommandExecutor.executeCommandOnArbitraryNode(client -> client.clusterKeySlot(JedisConverters.toString(key)).intValue()).getValue();
    }

    @Override
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        for (RedisClusterNode node : this.topologyProvider.getTopology().getSlotServingNodes(slot)) {
            if (!node.isMaster()) continue;
            return node;
        }
        return null;
    }

    public Set<RedisClusterNode> clusterGetNodes() {
        return this.topologyProvider.getTopology().getNodes();
    }

    public Set<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master cannot be null!");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        return JedisConverters.toSetOfRedisClusterNodes((Collection)this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterSlaves(nodeToUse.getId()), master).getValue());
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        List nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(client -> JedisConverters.toSetOfRedisClusterNodes(client.clusterSlaves((String)client.eval("return redis.call('cluster', 'myid')", 0, new String[0]))), this.topologyProvider.getTopology().getActiveMasterNodes()).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), (Collection<RedisClusterNode>)nodeResult.getValue());
        }
        return result;
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.clusterGetNodeForSlot(this.clusterGetSlotForKey(key));
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        return new ClusterInfo(JedisConverters.toProperties((String)this.clusterCommandExecutor.executeCommandOnArbitraryNode(Jedis::clusterInfo).getValue()));
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException translated = EXCEPTION_TRANSLATION.translate(ex);
        return translated != null ? translated : new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public void close() throws DataAccessException {
        if (!this.closed && this.disposeClusterCommandExecutorOnClose) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public JedisCluster getNativeConnection() {
        return this.cluster;
    }

    @Override
    public boolean isQueueing() {
        return false;
    }

    @Override
    public boolean isPipelined() {
        return false;
    }

    @Override
    public void openPipeline() {
        throw new UnsupportedOperationException("Pipeline is currently not supported for JedisClusterConnection.");
    }

    @Override
    public List<Object> closePipeline() throws RedisPipelineException {
        throw new UnsupportedOperationException("Pipeline is currently not supported for JedisClusterConnection.");
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        throw new UnsupportedOperationException("Sentinel is currently not supported for JedisClusterConnection.");
    }

    protected JedisCluster getCluster() {
        return this.cluster;
    }

    protected ClusterCommandExecutor getClusterCommandExecutor() {
        return this.clusterCommandExecutor;
    }

    protected JedisClusterTopologyProvider getTopologyProvider() {
        return this.topologyProvider;
    }

    static class JedisClusterTopologyProvider
    implements ClusterTopologyProvider {
        private final Object lock = new Object();
        private final JedisCluster cluster;
        private long time = 0L;
        @Nullable
        private ClusterTopology cached;

        public JedisClusterTopologyProvider(JedisCluster cluster) {
            this.cluster = cluster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterTopology getTopology() {
            if (this.cached != null && this.time + 100L > System.currentTimeMillis()) {
                return this.cached;
            }
            LinkedHashMap errors = new LinkedHashMap();
            for (Map.Entry entry : this.cluster.getClusterNodes().entrySet()) {
                Jedis jedis = null;
                try {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    this.time = System.currentTimeMillis();
                    Set<RedisClusterNode> nodes = Converters.toSetOfRedisClusterNodes(jedis.clusterNodes());
                    Object object = this.lock;
                    synchronized (object) {
                        this.cached = new ClusterTopology(nodes);
                    }
                    object = this.cached;
                    return object;
                }
                catch (Exception ex) {
                    errors.put(entry.getKey(), ex);
                }
                finally {
                    if (jedis == null) continue;
                    jedis.close();
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : errors.entrySet()) {
                sb.append(String.format("\r\n\t- %s failed: %s", entry.getKey(), ((Exception)entry.getValue()).getMessage()));
            }
            throw new ClusterStateFailureException("Could not retrieve cluster information. CLUSTER NODES returned with error." + sb.toString());
        }
    }

    static class JedisClusterNodeResourceProvider
    implements ClusterNodeResourceProvider {
        private final JedisCluster cluster;
        private final ClusterTopologyProvider topologyProvider;
        private final JedisClusterConnectionHandler connectionHandler;

        JedisClusterNodeResourceProvider(JedisCluster cluster, ClusterTopologyProvider topologyProvider) {
            DirectFieldAccessFallbackBeanWrapper accessor;
            this.cluster = cluster;
            this.topologyProvider = topologyProvider;
            this.connectionHandler = cluster != null ? ((accessor = new DirectFieldAccessFallbackBeanWrapper((Object)cluster)).isReadableProperty("connectionHandler") ? (JedisClusterConnectionHandler)accessor.getPropertyValue("connectionHandler") : null) : null;
        }

        public Jedis getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Cannot get Pool for 'null' node!");
            JedisPool pool = this.getResourcePoolForSpecificNode(node);
            if (pool != null) {
                return pool.getResource();
            }
            Jedis connection = this.getConnectionForSpecificNode(node);
            if (connection != null) {
                return connection;
            }
            throw new DataAccessResourceFailureException(String.format("Node %s is unknown to cluster", node));
        }

        private JedisPool getResourcePoolForSpecificNode(RedisClusterNode node) {
            Map clusterNodes = this.cluster.getClusterNodes();
            if (clusterNodes.containsKey(node.asString())) {
                return (JedisPool)clusterNodes.get(node.asString());
            }
            return null;
        }

        private Jedis getConnectionForSpecificNode(RedisClusterNode node) {
            RedisClusterNode member = this.topologyProvider.getTopology().lookup(node);
            if (member != null && this.connectionHandler != null) {
                return this.connectionHandler.getConnectionFromNode(new HostAndPort(member.getHost(), member.getPort().intValue()));
            }
            return null;
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object client) {
            ((Jedis)client).close();
        }
    }

    protected static interface JedisMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<Jedis, T> {
    }

    protected static interface JedisClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<Jedis, T> {
    }
}

