/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.util.RedisOutputStream;
import redis.clients.util.SafeEncoder;

class JedisClientUtils {
    private static final Field CLIENT_FIELD = ReflectionUtils.findField(BinaryJedis.class, (String)"client", Client.class);
    private static final Method SEND_COMMAND;
    private static final Method GET_RESPONSE;
    private static final Method PROTOCOL_SEND_COMMAND;
    private static final Set<String> KNOWN_COMMANDS;
    private static final Builder<Object> OBJECT_BUILDER;

    JedisClientUtils() {
    }

    static <T> T execute(String command, byte[][] keys, byte[][] args, Supplier<Jedis> jedis) {
        byte[][] commandArgs = JedisClientUtils.getCommandArguments(keys, args);
        Client client = JedisClientUtils.sendCommand(command, commandArgs, jedis.get());
        return (T)client.getOne();
    }

    static Client sendCommand(String command, byte[][] args, Jedis jedis) {
        Client client = JedisClientUtils.retrieveClient(jedis);
        JedisClientUtils.sendCommand(client, command, args);
        return client;
    }

    private static void sendCommand(Client client, String command, byte[][] args) {
        if (JedisClientUtils.isKnownCommand(command)) {
            ReflectionUtils.invokeMethod((Method)SEND_COMMAND, (Object)client, (Object[])new Object[]{Protocol.Command.valueOf((String)command.trim().toUpperCase()), args});
        } else {
            JedisClientUtils.sendProtocolCommand(client, command, args);
        }
    }

    private static void sendProtocolCommand(Client client, String command, byte[][] args) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)client);
        client.connect();
        RedisOutputStream os = (RedisOutputStream)dfa.getPropertyValue("outputStream");
        ReflectionUtils.invokeMethod((Method)PROTOCOL_SEND_COMMAND, null, (Object[])new Object[]{os, SafeEncoder.encode((String)command), args});
        Integer pipelinedCommands = (Integer)dfa.getPropertyValue("pipelinedCommands");
        dfa.setPropertyValue("pipelinedCommands", (Object)(pipelinedCommands + 1));
    }

    private static boolean isKnownCommand(String command) {
        return KNOWN_COMMANDS.contains(command);
    }

    private static byte[][] getCommandArguments(byte[][] keys, byte[][] args) {
        if (keys.length == 0) {
            return args;
        }
        if (args.length == 0) {
            return keys;
        }
        byte[][] commandArgs = new byte[keys.length + args.length][];
        System.arraycopy(keys, 0, commandArgs, 0, keys.length);
        System.arraycopy(args, 0, commandArgs, keys.length, args.length);
        return commandArgs;
    }

    static boolean isInMulti(Jedis jedis) {
        return JedisClientUtils.retrieveClient(jedis).isInMulti();
    }

    static Response<Object> getResponse(Object target) {
        return (Response)ReflectionUtils.invokeMethod((Method)GET_RESPONSE, (Object)target, (Object[])new Object[]{OBJECT_BUILDER});
    }

    private static Client retrieveClient(Jedis jedis) {
        return (Client)ReflectionUtils.getField((Field)CLIENT_FIELD, (Object)jedis);
    }

    static {
        ReflectionUtils.makeAccessible((Field)CLIENT_FIELD);
        PROTOCOL_SEND_COMMAND = ReflectionUtils.findMethod(Protocol.class, (String)"sendCommand", (Class[])new Class[]{RedisOutputStream.class, byte[].class, byte[][].class});
        ReflectionUtils.makeAccessible((Method)PROTOCOL_SEND_COMMAND);
        try {
            Class commandType = ClassUtils.isPresent((String)"redis.clients.jedis.ProtocolCommand", null) ? ClassUtils.forName((String)"redis.clients.jedis.ProtocolCommand", null) : ClassUtils.forName((String)"redis.clients.jedis.Protocol$Command", null);
            SEND_COMMAND = ReflectionUtils.findMethod(Connection.class, (String)"sendCommand", (Class[])new Class[]{commandType, byte[][].class});
        }
        catch (Exception e) {
            throw new NoClassDefFoundError("Could not find required flavor of command required by 'redis.clients.jedis.Connection#sendCommand'.");
        }
        ReflectionUtils.makeAccessible((Method)SEND_COMMAND);
        GET_RESPONSE = ReflectionUtils.findMethod(Queable.class, (String)"getResponse", (Class[])new Class[]{Builder.class});
        ReflectionUtils.makeAccessible((Method)GET_RESPONSE);
        KNOWN_COMMANDS = Arrays.stream(Protocol.Command.values()).map(Enum::name).collect(Collectors.toSet());
        OBJECT_BUILDER = new Builder<Object>(){

            public Object build(Object data) {
                return data;
            }

            public String toString() {
                return "Object";
            }
        };
    }
}

