/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveKeyCommands {
    default public Mono<Boolean> exists(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exists((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<DataType> type(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.type((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> touch(Collection<ByteBuffer> keys) {
        return this.touch((Publisher<Collection<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<Collection<ByteBuffer>, Long>> touch(Publisher<Collection<ByteBuffer>> var1);

    default public Mono<List<ByteBuffer>> keys(ByteBuffer pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return this.keys((Publisher<ByteBuffer>)Mono.just((Object)pattern)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> var1);

    public Mono<ByteBuffer> randomKey();

    default public Mono<Boolean> rename(ByteBuffer key, ByteBuffer newName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.rename((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(key).to(newName))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> rename(Publisher<RenameCommand> var1);

    default public Mono<Boolean> renameNX(ByteBuffer key, ByteBuffer newName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.renameNX((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(key).to(newName))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> renameNX(Publisher<RenameCommand> var1);

    default public Mono<Long> del(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.del((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> mDel(List<ByteBuffer> keys) {
        Assert.notEmpty(keys, (String)"Keys must not be empty or null!");
        return this.mDel((Publisher<List<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> var1);

    default public Mono<Long> unlink(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Keys must not be null!");
        return this.unlink((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)key).map(ReactiveRedisConnection.KeyCommand::new)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> unlink(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> mUnlink(List<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.mUnlink((Publisher<List<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mUnlink(Publisher<List<ByteBuffer>> var1);

    default public Mono<Boolean> expire(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        return this.expire((Publisher<ExpireCommand>)Mono.just((Object)new ExpireCommand(key, timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireCommand>> expire(Publisher<ExpireCommand> var1);

    default public Mono<Boolean> pExpire(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        return this.expire((Publisher<ExpireCommand>)Mono.just((Object)new ExpireCommand(key, timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireCommand>> pExpire(Publisher<ExpireCommand> var1);

    default public Mono<Boolean> expireAt(ByteBuffer key, Instant expireAt) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)expireAt, (String)"Expire at must not be null!");
        return this.expireAt((Publisher<ExpireAtCommand>)Mono.just((Object)new ExpireAtCommand(key, expireAt))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireAtCommand>> expireAt(Publisher<ExpireAtCommand> var1);

    default public Mono<Boolean> pExpireAt(ByteBuffer key, Instant expireAt) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)expireAt, (String)"Expire at must not be null!");
        return this.pExpireAt((Publisher<ExpireAtCommand>)Mono.just((Object)new ExpireAtCommand(key, expireAt))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ExpireAtCommand>> pExpireAt(Publisher<ExpireAtCommand> var1);

    default public Mono<Boolean> persist(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.persist((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> ttl(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.ttl((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> pTtl(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.pTtl((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Boolean> move(ByteBuffer key, int database) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.move((Publisher<MoveCommand>)Mono.just((Object)new MoveCommand(key, database))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<MoveCommand>> move(Publisher<MoveCommand> var1);

    public static class MoveCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Integer database;

        private MoveCommand(ByteBuffer key, @Nullable Integer database) {
            super(key);
            this.database = database;
        }

        public static MoveCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new MoveCommand(key, null);
        }

        public MoveCommand timeout(int database) {
            return new MoveCommand(this.getKey(), database);
        }

        @Nullable
        public Integer getDatabase() {
            return this.database;
        }
    }

    public static class ExpireAtCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Instant expireAt;

        private ExpireAtCommand(ByteBuffer key, @Nullable Instant expireAt) {
            super(key);
            this.expireAt = expireAt;
        }

        public static ExpireAtCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ExpireAtCommand(key, null);
        }

        public ExpireAtCommand timeout(Instant expireAt) {
            Assert.notNull((Object)expireAt, (String)"Expire at must not be null!");
            return new ExpireAtCommand(this.getKey(), expireAt);
        }

        @Nullable
        public Instant getExpireAt() {
            return this.expireAt;
        }
    }

    public static class ExpireCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Duration timeout;

        private ExpireCommand(ByteBuffer key, @Nullable Duration timeout) {
            super(key);
            this.timeout = timeout;
        }

        public static ExpireCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ExpireCommand(key, null);
        }

        public ExpireCommand timeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
            return new ExpireCommand(this.getKey(), timeout);
        }

        @Nullable
        public Duration getTimeout() {
            return this.timeout;
        }
    }

    public static class RenameCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private ByteBuffer newName;

        private RenameCommand(ByteBuffer key, @Nullable ByteBuffer newName) {
            super(key);
            this.newName = newName;
        }

        public static RenameCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new RenameCommand(key, null);
        }

        public RenameCommand to(ByteBuffer newName) {
            Assert.notNull((Object)newName, (String)"New name must not be null!");
            return new RenameCommand(this.getKey(), newName);
        }

        @Nullable
        public ByteBuffer getNewName() {
            return this.newName;
        }
    }
}

