/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

class LettuceServerCommands
implements RedisServerCommands {
    private final LettuceConnection connection;

    public LettuceServerCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().bgrewriteaof()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().bgrewriteaof()));
                return;
            }
            this.getConnection().bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().bgsave()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().bgsave()));
                return;
            }
            this.getConnection().bgsave();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().lastsave(), LettuceConverters.dateToLong()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().lastsave(), LettuceConverters.dateToLong()));
                return null;
            }
            return LettuceConverters.toLong(this.getConnection().lastsave());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().save()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().save()));
                return;
            }
            this.getConnection().save();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().dbsize()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().dbsize()));
                return null;
            }
            return this.getConnection().dbsize();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().flushdb()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().flushdb()));
                return;
            }
            this.getConnection().flushdb();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().flushall()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().flushall()));
                return;
            }
            this.getConnection().flushall();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().info(), LettuceConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().info(), LettuceConverters.stringToProps()));
                return null;
            }
            return LettuceConverters.toProperties(this.getConnection().info());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().info(section), LettuceConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().info(section), LettuceConverters.stringToProps()));
                return null;
            }
            return LettuceConverters.toProperties(this.getConnection().info(section));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.getAsyncConnection().shutdown(true);
                return;
            }
            this.getConnection().shutdown(true);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        boolean save = RedisServerCommands.ShutdownOption.SAVE.equals((Object)option);
        try {
            if (this.isPipelined()) {
                this.getAsyncConnection().shutdown(save);
                return;
            }
            this.getConnection().shutdown(save);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().configGet(param)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().configGet(param)));
                return null;
            }
            return this.getConnection().configGet(param);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().configSet(param, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().configSet(param, value)));
                return;
            }
            this.getConnection().configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().configResetstat()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().configResetstat()));
                return;
            }
            this.getConnection().configResetstat();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long time() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().time(), LettuceConverters.toTimeConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().time(), LettuceConverters.toTimeConverter()));
                return null;
            }
            return (Long)LettuceConverters.toTimeConverter().convert((Object)this.getConnection().time());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        String client = String.format("%s:%s", host, port);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().clientKill(client)));
                return;
            }
            this.getConnection().clientKill(client);
        }
        catch (Exception e) {
            throw this.convertLettuceAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        if (this.isQueueing()) {
            this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().clientSetname((Object)name)));
            return;
        }
        if (this.isQueueing()) {
            this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().clientSetname((Object)name)));
            return;
        }
        this.getAsyncConnection().clientSetname((Object)name);
    }

    @Override
    public String getClientName() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().clientGetname(), LettuceConverters.bytesToString()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().clientGetname(), LettuceConverters.bytesToString()));
                return null;
            }
            return LettuceConverters.toString((byte[])this.getConnection().clientGetname());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Cannot be called in pipeline mode.");
        }
        if (this.isQueueing()) {
            this.transaction(this.connection.newLettuceTxResult(this.getAsyncConnection().clientList(), LettuceConverters.stringToRedisClientListConverter()));
            return null;
        }
        return LettuceConverters.toListOfRedisClientInformation(this.getConnection().clientList());
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().slaveof(host, port)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().slaveof(host, port)));
                return;
            }
            this.getConnection().slaveof(host, port);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void slaveOfNoOne() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().slaveofNoOne()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().slaveofNoOne()));
                return;
            }
            this.getConnection().slaveofNoOne();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().migrate(target.getHost(), target.getPort().intValue(), (Object)key, dbIndex, timeout)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().migrate(target.getHost(), target.getPort().intValue(), (Object)key, dbIndex, timeout)));
                return;
            }
            this.getConnection().migrate(target.getHost(), target.getPort().intValue(), (Object)key, dbIndex, timeout);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceConnection.LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceConnection.LettuceTxResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }
}

