/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import java.nio.ByteBuffer;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterNumberCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

class LettuceReactiveRedisClusterConnection
extends LettuceReactiveRedisConnection
implements ReactiveRedisClusterConnection {
    public LettuceReactiveRedisClusterConnection(RedisClusterClient client) {
        super((AbstractRedisClient)client);
    }

    @Override
    public LettuceReactiveClusterKeyCommands keyCommands() {
        return new LettuceReactiveClusterKeyCommands(this);
    }

    @Override
    public LettuceReactiveClusterListCommands listCommands() {
        return new LettuceReactiveClusterListCommands(this);
    }

    @Override
    public LettuceReactiveClusterSetCommands setCommands() {
        return new LettuceReactiveClusterSetCommands(this);
    }

    @Override
    public LettuceReactiveClusterZSetCommands zSetCommands() {
        return new LettuceReactiveClusterZSetCommands(this);
    }

    @Override
    public LettuceReactiveClusterHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceReactiveClusterHyperLogLogCommands(this);
    }

    @Override
    public LettuceReactiveClusterStringCommands stringCommands() {
        return new LettuceReactiveClusterStringCommands(this);
    }

    @Override
    public LettuceReactiveClusterGeoCommands geoCommands() {
        return new LettuceReactiveClusterGeoCommands(this);
    }

    @Override
    public LettuceReactiveClusterHashCommands hashCommands() {
        return new LettuceReactiveClusterHashCommands(this);
    }

    @Override
    public LettuceReactiveClusterNumberCommands numberCommands() {
        return new LettuceReactiveClusterNumberCommands(this);
    }

    public <T> Flux<T> execute(RedisNode node, LettuceReactiveRedisConnection.LettuceReactiveCallback<T> callback) {
        try {
            Assert.notNull(callback, (String)"ReactiveCallback must not be null!");
            Assert.notNull((Object)node, (String)"Node must not be null!");
        }
        catch (IllegalArgumentException e) {
            return Flux.error((Throwable)e);
        }
        return Flux.defer(() -> callback.doWithCommands((RedisClusterReactiveCommands<ByteBuffer, ByteBuffer>)this.getCommands(node))).onErrorMap(this.translateException());
    }

    protected StatefulRedisClusterConnection<ByteBuffer, ByteBuffer> getConnection() {
        Assert.isInstanceOf(StatefulRedisClusterConnection.class, super.getConnection(), (String)"Connection needs to be instance of StatefulRedisClusterConnection");
        return (StatefulRedisClusterConnection)super.getConnection();
    }

    @Override
    protected RedisClusterReactiveCommands<ByteBuffer, ByteBuffer> getCommands() {
        return this.getConnection().reactive();
    }

    protected RedisReactiveCommands<ByteBuffer, ByteBuffer> getCommands(RedisNode node) {
        if (!(this.getConnection() instanceof StatefulRedisClusterConnection)) {
            throw new IllegalArgumentException("o.O connection needs to be cluster compatible " + this.getConnection());
        }
        if (StringUtils.hasText((String)node.getId())) {
            return this.getConnection().getConnection(node.getId()).reactive();
        }
        return this.getConnection().getConnection(node.getHost(), node.getPort().intValue()).reactive();
    }
}

