/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.DefaultLettuceClientConfiguration;
import org.springframework.util.Assert;

public interface LettuceClientConfiguration {
    public boolean isUseSsl();

    public boolean isVerifyPeer();

    public boolean isStartTls();

    public Optional<ClientResources> getClientResources();

    public Optional<ClientOptions> getClientOptions();

    public Duration getCommandTimeout();

    public Duration getShutdownTimeout();

    public static LettuceClientConfigurationBuilder builder() {
        return new DefaultLettuceClientConfigurationBuilder();
    }

    public static LettuceClientConfiguration defaultConfiguration() {
        return LettuceClientConfiguration.builder().build();
    }

    public static class DefaultLettuceClientConfigurationBuilder
    implements LettuceClientConfigurationBuilder,
    LettuceSslClientConfigurationBuilder {
        private boolean useSsl;
        private boolean verifyPeer = true;
        private boolean startTls;
        private ClientResources clientResources;
        private ClientOptions clientOptions;
        private Duration timeout = Duration.ofSeconds(60L);
        private Duration shutdownTimeout = Duration.ofSeconds(2L);

        private DefaultLettuceClientConfigurationBuilder() {
        }

        @Override
        public LettuceSslClientConfigurationBuilder useSsl() {
            this.useSsl = true;
            return this;
        }

        @Override
        public LettuceSslClientConfigurationBuilder disablePeerVerification() {
            this.verifyPeer = false;
            return this;
        }

        @Override
        public LettuceSslClientConfigurationBuilder startTls() {
            this.startTls = true;
            return this;
        }

        @Override
        public LettuceClientConfigurationBuilder and() {
            return this;
        }

        @Override
        public LettuceClientConfigurationBuilder clientResources(ClientResources clientResources) {
            Assert.notNull((Object)clientResources, (String)"ClientResources must not be null!");
            this.clientResources = clientResources;
            return this;
        }

        @Override
        public LettuceClientConfigurationBuilder clientOptions(ClientOptions clientOptions) {
            Assert.notNull((Object)clientOptions, (String)"ClientOptions must not be null!");
            this.clientOptions = clientOptions;
            return this;
        }

        @Override
        public LettuceClientConfigurationBuilder commandTimeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Duration must not be null!");
            this.timeout = timeout;
            return this;
        }

        @Override
        public LettuceClientConfigurationBuilder shutdownTimeout(Duration shutdownTimeout) {
            Assert.notNull((Object)this.timeout, (String)"Duration must not be null!");
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        @Override
        public LettuceClientConfiguration build() {
            return new DefaultLettuceClientConfiguration(this.useSsl, this.verifyPeer, this.startTls, this.clientResources, this.clientOptions, this.timeout, this.shutdownTimeout);
        }
    }

    public static interface LettuceSslClientConfigurationBuilder {
        public LettuceSslClientConfigurationBuilder disablePeerVerification();

        public LettuceSslClientConfigurationBuilder startTls();

        public LettuceClientConfigurationBuilder and();

        public LettuceClientConfiguration build();
    }

    public static interface LettuceClientConfigurationBuilder {
        public LettuceSslClientConfigurationBuilder useSsl();

        public LettuceClientConfigurationBuilder clientResources(ClientResources var1);

        public LettuceClientConfigurationBuilder clientOptions(ClientOptions var1);

        public LettuceClientConfigurationBuilder commandTimeout(Duration var1);

        public LettuceClientConfigurationBuilder shutdownTimeout(Duration var1);

        public LettuceClientConfiguration build();
    }
}

