/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.ObjectUtils;

class JedisStringCommands
implements RedisStringCommands {
    private final JedisConnection connection;

    public JedisStringCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().get(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().get(key)));
                return null;
            }
            return this.connection.getJedis().get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().getSet(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().getSet(key, value)));
                return null;
            }
            return this.connection.getJedis().getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().mget(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().mget(keys)));
                return null;
            }
            return this.connection.getJedis().mget(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().set(key, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().set(key, value)));
                return;
            }
            this.connection.getJedis().set(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null || expiration.isPersistent()) {
            if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
                this.set(key, value);
            } else {
                try {
                    byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
                    if (this.isPipelined()) {
                        this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().set(key, value, nxxx)));
                        return;
                    }
                    if (this.isQueueing()) {
                        this.transaction(this.connection.newStatusResult(this.connection.getTransaction().set(key, value, nxxx)));
                        return;
                    }
                    this.connection.getJedis().set(key, value, nxxx);
                }
                catch (Exception ex) {
                    throw this.convertJedisAccessException(ex);
                }
            }
        } else if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                this.pSetEx(key, expiration.getExpirationTime(), value);
            } else {
                this.setEx(key, expiration.getExpirationTime(), value);
            }
        } else {
            byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
            byte[] expx = JedisConverters.toSetCommandExPxArgument(expiration);
            try {
                if (this.isPipelined()) {
                    if (expiration.getExpirationTime() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Expiration.expirationTime must be less than Integer.MAX_VALUE for pipeline in Jedis.");
                    }
                    this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().set(key, value, nxxx, expx, (int)expiration.getExpirationTime())));
                    return;
                }
                if (this.isQueueing()) {
                    if (expiration.getExpirationTime() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Expiration.expirationTime must be less than Integer.MAX_VALUE for transactions in Jedis.");
                    }
                    this.transaction(this.connection.newStatusResult(this.connection.getTransaction().set(key, value, nxxx, expx, (int)expiration.getExpirationTime())));
                    return;
                }
                this.connection.getJedis().set(key, value, nxxx, expx, expiration.getExpirationTime());
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Time must be less than Integer.MAX_VALUE for setEx in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().setex(key, (int)seconds, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().setex(key, (int)seconds, value)));
                return;
            }
            this.connection.getJedis().setex(key, (int)seconds, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().psetex(key, milliseconds, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().psetex(key, milliseconds, value)));
                return;
            }
            this.connection.getJedis().psetex(key, milliseconds, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().mset(JedisConverters.toByteArrays(tuples))));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().mset(JedisConverters.toByteArrays(tuples))));
                return;
            }
            this.connection.getJedis().mset(JedisConverters.toByteArrays(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().msetnx(JedisConverters.toByteArrays(tuples)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().incr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().incr(key)));
                return null;
            }
            return this.connection.getJedis().incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().incrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().incrBy(key, value)));
                return null;
            }
            return this.connection.getJedis().incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().incrByFloat(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().incrByFloat(key, value)));
                return null;
            }
            return this.connection.getJedis().incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().decr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().decr(key)));
                return null;
            }
            return this.connection.getJedis().decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().decrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().decrBy(key, value)));
                return null;
            }
            return this.connection.getJedis().decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().append(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().append(key, value)));
                return null;
            }
            return this.connection.getJedis().append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        if (start > Integer.MAX_VALUE || end > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Start and end must be less than Integer.MAX_VALUE for getRange in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            return this.connection.getJedis().substr(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().setrange(key, start, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().setrange(key, start, value)));
                return;
            }
            this.connection.getJedis().setrange(key, start, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().getbit(key, offset)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().getbit(key, offset)));
                return null;
            }
            Boolean getBit = this.connection.getJedis().getbit(key, offset);
            if (getBit instanceof Long) {
                return (Long)((Object)getBit) == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            return getBit;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            return this.connection.getJedis().setbit(key, offset, JedisConverters.toBit(value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().bitcount(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().bitcount(key)));
                return null;
            }
            return this.connection.getJedis().bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().bitcount(key, begin, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().bitcount(key, begin, end)));
                return null;
            }
            return this.connection.getJedis().bitcount(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            return this.connection.getJedis().bitop(JedisConverters.toBitOp(op), destination, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().strlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().strlen(key)));
                return null;
            }
            return this.connection.getJedis().strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

