/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Properties;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

class JedisServerCommands
implements RedisServerCommands {
    private static final String SHUTDOWN_SCRIPT = "return redis.call('SHUTDOWN','%s')";
    private final JedisConnection connection;

    public JedisServerCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().bgrewriteaof()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().bgrewriteaof()));
                return;
            }
            this.connection.getJedis().bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().bgsave()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().bgsave()));
                return;
            }
            this.connection.getJedis().bgsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lastsave()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lastsave()));
                return null;
            }
            return this.connection.getJedis().lastsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().save()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().save()));
                return;
            }
            this.connection.getJedis().save();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().dbSize()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().dbSize()));
                return null;
            }
            return this.connection.getJedis().dbSize();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().flushDB()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().flushDB()));
                return;
            }
            this.connection.getJedis().flushDB();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().flushAll()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().flushAll()));
                return;
            }
            this.connection.getJedis().flushAll();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().info(), JedisConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().info(), JedisConverters.stringToProps()));
                return null;
            }
            return JedisConverters.toProperties(this.connection.getJedis().info());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            return JedisConverters.toProperties(this.connection.getJedis().info(section));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().shutdown()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().shutdown()));
                return;
            }
            this.connection.getJedis().shutdown();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        this.connection.eval(String.format(SHUTDOWN_SCRIPT, option.name()).getBytes(), ReturnType.STATUS, 0, new byte[0][]);
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().configGet(param)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().configGet(param)));
                return null;
            }
            return this.connection.getJedis().configGet(param);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().configSet(param, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().configSet(param, value)));
                return;
            }
            this.connection.getJedis().configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().configResetStat()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().configResetStat()));
                return;
            }
            this.connection.getJedis().configResetStat();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long time() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().time(), JedisConverters.toTimeConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().time(), JedisConverters.toTimeConverter()));
                return null;
            }
            return (Long)JedisConverters.toTimeConverter().convert((Object)this.connection.getJedis().time());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT KILL' is not supported in transaction / pipline mode.");
        }
        try {
            this.connection.getJedis().clientKill(String.format("%s:%s", host, port));
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("'CLIENT SETNAME' is not suppored in transacton / pipeline mode.");
        }
        this.connection.getJedis().clientSetname(name);
    }

    @Override
    public String getClientName() {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        return this.connection.getJedis().clientGetname();
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT LIST' is not supported in in pipeline / multi mode.");
        }
        return JedisConverters.toListOfRedisClientInformation(this.connection.getJedis().clientList());
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.connection.getJedis().slaveof(host, port);
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void slaveOfNoOne() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.connection.getJedis().slaveofNoOne();
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse)));
                return;
            }
            this.connection.getJedis().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

