/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;

class JedisClusterZSetCommands
implements RedisZSetCommands {
    private final JedisClusterConnection connection;

    public JedisClusterZSetCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            return this.connection.getCluster().zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            return this.connection.getCluster().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().zrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return this.connection.getCluster().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount());
            }
            return this.connection.getCluster().zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZCOUNT.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREMRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit != null) {
                return this.connection.getCluster().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getCluster().zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYLEX.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.toBytes("-"));
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.toBytes("+"));
        try {
            if (limit != null) {
                return this.connection.getCluster().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getCluster().zrangeByLex(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long begin, long end) {
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeWithScores(key, begin, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            return this.connection.getCluster().zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrangeByScore(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().zrevrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long begin, long end) {
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeWithScores(key, begin, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            return this.connection.getCluster().zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrevrangeByScore(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            return this.connection.getCluster().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().zremrangeByRank(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zunionstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.connection.getCluster().zunionstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zinterstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.connection.getCluster().zinterstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new IllegalArgumentException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(final byte[] key, ScanOptions options) {
        return new ScanCursor<RedisZSetCommands.Tuple>(options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterZSetCommands.this.connection.getCluster().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        try {
            return this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

