/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.CollectionUtils;

class JedisClusterListCommands
implements RedisListCommands {
    private final JedisClusterConnection connection;

    public JedisClusterListCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            return this.connection.getCluster().rpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            return this.connection.getCluster().lpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().rpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().lpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            return this.connection.getCluster().llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().lrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long begin, long end) {
        try {
            this.connection.getCluster().ltrim(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            return this.connection.getCluster().lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            return this.connection.getCluster().linsert(key, JedisConverters.toListPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            this.connection.getCluster().lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            return this.connection.getCluster().lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            return this.connection.getCluster().lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            return this.connection.getCluster().rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().blpop(timeout, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMuliKeyCommand((client, key) -> client.blpop(timeout, (byte[][])new byte[][]{key}), Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return this.connection.getClusterCommandExecutor().executeMuliKeyCommand((client, key) -> client.brpop(timeout, (byte[][])new byte[][]{key}), Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.connection.getCluster().rpoplpush(srcKey, dstKey);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] val = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val});
        return val;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.connection.getCluster().brpoplpush(srcKey, dstKey, timeout);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<byte[]> val = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val)) {
            this.lPush(dstKey, new byte[][]{val.get(1)});
            return val.get(1);
        }
        return null;
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

