/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisSentinelConfiguration {
    private static final String REDIS_SENTINEL_MASTER_CONFIG_PROPERTY = "spring.redis.sentinel.master";
    private static final String REDIS_SENTINEL_NODES_CONFIG_PROPERTY = "spring.redis.sentinel.nodes";
    private NamedNode master;
    private Set<RedisNode> sentinels;
    private int database;
    private RedisPassword password = RedisPassword.none();

    public RedisSentinelConfiguration() {
        this((PropertySource<?>)new MapPropertySource("RedisSentinelConfiguration", Collections.emptyMap()));
    }

    public RedisSentinelConfiguration(String master, Set<String> sentinelHostAndPorts) {
        this((PropertySource<?>)new MapPropertySource("RedisSentinelConfiguration", RedisSentinelConfiguration.asMap(master, sentinelHostAndPorts)));
    }

    public RedisSentinelConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null!");
        this.sentinels = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY)) {
            this.setMaster(propertySource.getProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY).toString());
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY)) {
            this.appendSentinels(StringUtils.commaDelimitedListToSet((String)propertySource.getProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY).toString()));
        }
    }

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, (String)"Cannot set sentinels to 'null'.");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, (String)"Sentinel must not be 'null'.");
        this.sentinels.add(sentinel);
    }

    public void setMaster(String name) {
        Assert.notNull((Object)name, (String)"Name of sentinel master must not be null.");
        this.setMaster(() -> name);
    }

    public void setMaster(NamedNode master) {
        Assert.notNull((Object)master, (String)"Sentinel master node must not be 'null'.");
        this.master = master;
    }

    public NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }

    private void appendSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(this.readHostAndPortFromString(hostAndPort));
        }
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    public RedisPassword getPassword() {
        return this.password;
    }

    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null!");
        this.password = password;
    }

    private RedisNode readHostAndPortFromString(String hostAndPort) {
        String[] args = StringUtils.split((String)hostAndPort, (String)":");
        Assert.notNull((Object)args, (String)"HostAndPort need to be seperated by  ':'.");
        Assert.isTrue((args.length == 2 ? 1 : 0) != 0, (String)"Host and Port String needs to specified as host:port");
        return new RedisNode(args[0], Integer.valueOf(args[1]));
    }

    private static Map<String, Object> asMap(String master, Set<String> sentinelHostAndPorts) {
        Assert.hasText((String)master, (String)"Master address must not be null or empty!");
        Assert.notNull(sentinelHostAndPorts, (String)"SentinelHostAndPorts must not be null!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY, master);
        map.put(REDIS_SENTINEL_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(sentinelHostAndPorts));
        return map;
    }
}

