/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.IndexedDataFactoryProvider;
import org.springframework.data.redis.core.convert.RemoveIndexedData;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.GeoIndexDefinition;
import org.springframework.data.redis.core.index.GeoIndexed;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.Indexed;
import org.springframework.data.redis.core.index.SimpleIndexDefinition;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class PathIndexResolver
implements IndexResolver {
    private final Set<Class<?>> VALUE_TYPES = new HashSet<Class>(Arrays.asList(Point.class, RedisGeoCommands.GeoLocation.class));
    private ConfigurableIndexDefinitionProvider indexConfiguration;
    private RedisMappingContext mappingContext;
    private IndexedDataFactoryProvider indexedDataFactoryProvider;

    public PathIndexResolver() {
        this(new RedisMappingContext());
    }

    public PathIndexResolver(RedisMappingContext mappingContext) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.indexConfiguration = mappingContext.getMappingConfiguration().getIndexConfiguration();
        this.indexedDataFactoryProvider = new IndexedDataFactoryProvider();
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(TypeInformation<?> typeInformation, Object value) {
        return this.doResolveIndexesFor(((RedisPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation).get()).getKeySpace(), "", typeInformation, null, value);
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(String keyspace, String path, TypeInformation<?> typeInformation, Object value) {
        return this.doResolveIndexesFor(keyspace, path, typeInformation, null, value);
    }

    private Set<IndexedData> doResolveIndexesFor(final String keyspace, final String path, TypeInformation<?> typeInformation, PersistentProperty<?> fallback, Object value) {
        Optional entity = this.mappingContext.getPersistentEntity(typeInformation);
        if (!entity.isPresent() || value != null && this.VALUE_TYPES.contains(value.getClass())) {
            return this.resolveIndex(keyspace, path, fallback, value);
        }
        if (!ClassUtils.isAssignable((Class)((RedisPersistentEntity)entity.get()).getType(), value.getClass())) {
            String propertyName = path.lastIndexOf(46) > 0 ? path.substring(path.lastIndexOf(46) + 1, path.length()) : path;
            return this.resolveIndex(keyspace, path, (PersistentProperty)((RedisPersistentEntity)entity.get()).getPersistentProperty(propertyName).get(), value);
        }
        final PersistentPropertyAccessor accessor = ((RedisPersistentEntity)entity.get()).getPropertyAccessor(value);
        final LinkedHashSet<IndexedData> indexes = new LinkedHashSet<IndexedData>();
        ((RedisPersistentEntity)entity.get()).doWithProperties((PropertyHandler)new PropertyHandler<RedisPersistentProperty>(){

            public void doWithPersistentProperty(RedisPersistentProperty persistentProperty) {
                String currentPath = !path.isEmpty() ? path + "." + persistentProperty.getName() : persistentProperty.getName();
                Optional propertyValue = accessor.getProperty((PersistentProperty)persistentProperty);
                if (propertyValue.isPresent()) {
                    TypeInformation<?> typeHint;
                    Object object = typeHint = persistentProperty.isMap() ? (TypeInformation)persistentProperty.getTypeInformation().getMapValueType().get() : persistentProperty.getTypeInformation().getActualType();
                    if (persistentProperty.isMap()) {
                        for (Map.Entry entry : ((Map)propertyValue.get()).entrySet()) {
                            TypeInformation<?> typeToUse = this.updateTypeHintForActualValue(typeHint, entry.getValue());
                            indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath + "." + entry.getKey(), typeToUse.getActualType(), (PersistentProperty)persistentProperty, entry.getValue()));
                        }
                    } else if (persistentProperty.isCollectionLike()) {
                        Iterable iterable;
                        if (Iterable.class.isAssignableFrom(propertyValue.get().getClass())) {
                            iterable = (Iterable)propertyValue.get();
                        } else if (propertyValue.get().getClass().isArray()) {
                            iterable = CollectionUtils.arrayToList(propertyValue.get());
                        } else {
                            throw new RuntimeException("Don't know how to handle " + propertyValue.get().getClass() + " type of collection");
                        }
                        for (Object listValue : iterable) {
                            if (listValue == null) continue;
                            TypeInformation<?> typeToUse = this.updateTypeHintForActualValue(typeHint, listValue);
                            indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath, typeToUse.getActualType(), (PersistentProperty)persistentProperty, listValue));
                        }
                    } else if (persistentProperty.isEntity() || persistentProperty.getTypeInformation().getActualType().equals(ClassTypeInformation.OBJECT)) {
                        typeHint = this.updateTypeHintForActualValue(typeHint, propertyValue.get());
                        indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath, typeHint.getActualType(), (PersistentProperty)persistentProperty, propertyValue.get()));
                    } else {
                        indexes.addAll(PathIndexResolver.this.resolveIndex(keyspace, currentPath, (PersistentProperty<?>)persistentProperty, propertyValue.get()));
                    }
                }
            }

            private TypeInformation<?> updateTypeHintForActualValue(TypeInformation<?> typeHint, Object propertyValue) {
                if (typeHint.equals(ClassTypeInformation.OBJECT) || typeHint.getClass().isInterface()) {
                    try {
                        typeHint = ((RedisPersistentEntity)PathIndexResolver.this.mappingContext.getPersistentEntity(propertyValue.getClass()).get()).getTypeInformation();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return typeHint;
            }
        });
        return indexes;
    }

    protected Set<IndexedData> resolveIndex(String keyspace, String propertyPath, PersistentProperty<?> property, Object value) {
        String path = this.normalizeIndexPath(propertyPath, property);
        LinkedHashSet<IndexedData> data = new LinkedHashSet<IndexedData>();
        if (this.indexConfiguration.hasIndexFor((Serializable)((Object)keyspace), path)) {
            IndexDefinition.IndexingContext context = new IndexDefinition.IndexingContext(keyspace, path, (TypeInformation<?>)(property != null ? property.getTypeInformation() : ClassTypeInformation.OBJECT));
            for (IndexDefinition indexDefinition : this.indexConfiguration.getIndexDefinitionsFor((Serializable)((Object)keyspace), path)) {
                if (!this.verifyConditions(indexDefinition.getConditions(), value, context)) continue;
                Object transformedValue = indexDefinition.valueTransformer().convert(value);
                IndexedData indexedData = null;
                indexedData = transformedValue == null ? new RemoveIndexedData(indexedData) : this.indexedDataFactoryProvider.getIndexedDataFactory(indexDefinition).createIndexedDataFor(value);
                data.add(indexedData);
            }
        } else if (property != null && property.isAnnotationPresent(Indexed.class)) {
            SimpleIndexDefinition indexDefinition = new SimpleIndexDefinition(keyspace, path);
            this.indexConfiguration.addIndexDefinition(indexDefinition);
            data.add(this.indexedDataFactoryProvider.getIndexedDataFactory(indexDefinition).createIndexedDataFor(value));
        } else if (property != null && property.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexDefinition indexDefinition = new GeoIndexDefinition(keyspace, path);
            this.indexConfiguration.addIndexDefinition(indexDefinition);
            data.add(this.indexedDataFactoryProvider.getIndexedDataFactory(indexDefinition).createIndexedDataFor(value));
        }
        return data;
    }

    private boolean verifyConditions(Iterable<IndexDefinition.Condition<?>> conditions, Object value, IndexDefinition.IndexingContext context) {
        for (IndexDefinition.Condition<?> condition : conditions) {
            if (condition.matches(value, context)) continue;
            return false;
        }
        return true;
    }

    private String normalizeIndexPath(String path, PersistentProperty<?> property) {
        if (property == null) {
            return path;
        }
        if (property.isMap()) {
            return path.replaceAll("\\[", "").replaceAll("\\]", "");
        }
        if (property.isCollectionLike()) {
            return path.replaceAll("\\[(\\p{Digit})*\\]", "").replaceAll("\\.\\.", ".");
        }
        return path;
    }
}

