/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.Expiration;

class LettuceStringCommands
implements RedisStringCommands {
    private final LettuceConnection connection;

    public LettuceStringCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().get((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().get((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().set((Object)key, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().set((Object)key, (Object)value)));
                return;
            }
            this.getConnection().set((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option))));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option))));
                return;
            }
            this.getConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().getset((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getset((Object)key, (Object)value)));
                return null;
            }
            return (byte[])this.getConnection().getset((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().append((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().append((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().append((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().mget((Object[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().mget((Object[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            return LettuceConverters.keyValueListUnwrapper().convert(this.getConnection().mget((Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().mset(tuples)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().mset(tuples)));
                return;
            }
            this.getConnection().mset(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().msetnx(tuples)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().msetnx(tuples)));
                return null;
            }
            return this.getConnection().msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().setex((Object)key, time, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().setex((Object)key, time, (Object)value)));
                return;
            }
            this.getConnection().setex((Object)key, time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().psetex((Object)key, milliseconds, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().psetex((Object)key, milliseconds, (Object)value)));
                return;
            }
            this.getConnection().psetex((Object)key, milliseconds, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().setnx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().getrange((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getrange((Object)key, start, end)));
                return null;
            }
            return (byte[])this.getConnection().getrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().decr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().decr((Object)key)));
                return null;
            }
            return this.getConnection().decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().decrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().decrby((Object)key, value)));
                return null;
            }
            return this.getConnection().decrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().incr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incr((Object)key)));
                return null;
            }
            return this.getConnection().incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().incrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incrby((Object)key, value)));
                return null;
            }
            return this.getConnection().incrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            return this.getConnection().incrbyfloat((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().getbit((Object)key, offset));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return (Boolean)LettuceConverters.longToBooleanConverter().convert((Object)this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().setrange((Object)key, start, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().setrange((Object)key, start, (Object)value)));
                return;
            }
            this.getConnection().setrange((Object)key, start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().strlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().strlen((Object)key)));
                return null;
            }
            return this.getConnection().strlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().bitcount((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().bitcount((Object)key)));
                return null;
            }
            return this.getConnection().bitcount((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().bitcount((Object)key, begin, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().bitcount((Object)key, begin, end)));
                return null;
            }
            return this.getConnection().bitcount((Object)key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.asyncBitOp(op, destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.syncBitOp(op, destination, keys)));
                return null;
            }
            return this.syncBitOp(op, destination, keys);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private Future<Long> asyncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getAsyncConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getAsyncConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getAsyncConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getAsyncConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private Long syncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceConnection.LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceConnection.LettuceTxResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }
}

