/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.lettuce.core.sentinel.api.sync.RedisSentinelCommands;
import java.io.IOException;
import java.util.List;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.util.Assert;

public class LettuceSentinelConnection
implements RedisSentinelConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private RedisClient redisClient;
    private StatefulRedisSentinelConnection<String, String> connection;

    public LettuceSentinelConnection(RedisNode sentinel) {
        this(sentinel.getHost(), sentinel.getPort());
    }

    public LettuceSentinelConnection(String host, int port) {
        Assert.notNull((Object)host, (String)"Cannot create LettuceSentinelConnection using 'null' as host.");
        this.redisClient = RedisClient.create((RedisURI)RedisURI.Builder.redis((String)host, (int)port).build());
        this.init();
    }

    public LettuceSentinelConnection(String host, int port, ClientResources clientResources) {
        Assert.notNull((Object)clientResources, (String)"Cannot create LettuceSentinelConnection using 'null' as ClientResources.");
        Assert.notNull((Object)host, (String)"Cannot create LettuceSentinelConnection using 'null' as host.");
        this.redisClient = RedisClient.create((ClientResources)clientResources, (RedisURI)RedisURI.Builder.redis((String)host, (int)port).build());
        this.init();
    }

    public LettuceSentinelConnection(RedisClient redisClient) {
        Assert.notNull((Object)redisClient, (String)"Cannot create LettuceSentinelConnection using 'null' as client.");
        this.redisClient = redisClient;
        this.init();
    }

    protected LettuceSentinelConnection(StatefulRedisSentinelConnection<String, String> connection) {
        Assert.notNull(connection, (String)"Cannot create LettuceSentinelConnection using 'null' as connection.");
        this.connection = connection;
    }

    @Override
    public void failover(NamedNode master) {
        Assert.notNull((Object)master, (String)"Redis node master must not be 'null' for failover.");
        Assert.hasText((String)master.getName(), (String)"Redis master name must not be 'null' or empty for failover.");
        this.getSentinelCommands().failover((Object)master.getName());
    }

    public List<RedisServer> masters() {
        try {
            return LettuceConverters.toListOfRedisServer(this.getSentinelCommands().masters());
        }
        catch (Exception e) {
            throw EXCEPTION_TRANSLATION.translate(e);
        }
    }

    public List<RedisServer> slaves(NamedNode master) {
        Assert.notNull((Object)master, (String)"Master node cannot be 'null' when loading slaves.");
        return this.slaves(master.getName());
    }

    public List<RedisServer> slaves(String masterName) {
        Assert.hasText((String)masterName, (String)"Name of redis master cannot be 'null' or empty when loading slaves.");
        try {
            return LettuceConverters.toListOfRedisServer(this.getSentinelCommands().slaves((Object)masterName));
        }
        catch (Exception e) {
            throw EXCEPTION_TRANSLATION.translate(e);
        }
    }

    @Override
    public void remove(NamedNode master) {
        Assert.notNull((Object)master, (String)"Master node cannot be 'null' when trying to remove.");
        this.remove(master.getName());
    }

    public void remove(String masterName) {
        Assert.hasText((String)masterName, (String)"Name of redis master cannot be 'null' or empty when trying to remove.");
        this.getSentinelCommands().remove((Object)masterName);
    }

    @Override
    public void monitor(RedisServer server) {
        Assert.notNull((Object)server, (String)"Cannot monitor 'null' server.");
        Assert.hasText((String)server.getName(), (String)"Name of server to monitor must not be 'null' or empty.");
        Assert.hasText((String)server.getHost(), (String)"Host must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getPort(), (String)"Port must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getQuorum(), (String)"Quorum must not be 'null' for server to monitor.");
        this.getSentinelCommands().monitor((Object)server.getName(), server.getHost(), server.getPort().intValue(), server.getQuorum().intValue());
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
        this.connection = null;
        if (this.redisClient != null) {
            this.redisClient.shutdown();
        }
    }

    private void init() {
        if (this.connection == null) {
            this.connection = this.connectSentinel();
        }
    }

    private RedisSentinelCommands<String, String> getSentinelCommands() {
        return this.connection.sync();
    }

    private StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.redisClient.connectSentinel();
    }

    @Override
    public boolean isOpen() {
        return this.connection != null && this.connection.isOpen();
    }
}

