/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

class LettuceKeyCommands
implements RedisKeyCommands {
    private final LettuceConnection connection;

    public LettuceKeyCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] dump(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().dump((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().dump((Object)key)));
                return null;
            }
            return this.getConnection().dump((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().restore((Object)key, ttlInMillis, serializedValue)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().restore((Object)key, ttlInMillis, serializedValue)));
                return;
            }
            this.getConnection().restore((Object)key, ttlInMillis, serializedValue);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().keys((Object)pattern));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().exists((Object[])new byte[][]{key}), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getAsyncConnection().exists((Object[])new byte[][]{key}), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return (Boolean)LettuceConverters.longToBooleanConverter().convert((Object)this.getConnection().exists((Object[])new byte[][]{key}));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().expire((Object)key, seconds)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().expire((Object)key, seconds)));
                return null;
            }
            return this.getConnection().expire((Object)key, seconds);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().expireat((Object)key, unixTime)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().expireat((Object)key, unixTime)));
                return null;
            }
            return this.getConnection().expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().pexpire((Object)key, millis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().pexpire((Object)key, millis)));
                return null;
            }
            return this.getConnection().pexpire((Object)key, millis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            return this.getConnection().pexpireat((Object)key, unixTimeInMillis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().pttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().pttl((Object)key)));
                return null;
            }
            return this.getConnection().pttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().pttl((Object)key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().pttl((Object)key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.millisecondsToTimeUnit(this.getConnection().pttl((Object)key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().del((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().del((Object[])keys)));
                return null;
            }
            return this.getConnection().del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sort((Object)key, args)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sort((Object)key, args)));
                return null;
            }
            return this.getConnection().sort((Object)key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            return this.getConnection().sortStore((Object)key, args, (Object)sortKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().persist((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().persist((Object)key)));
                return null;
            }
            return this.getConnection().persist((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().move((Object)key, dbIndex)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().move((Object)key, dbIndex)));
                return null;
            }
            return this.getConnection().move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().randomkey()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().randomkey()));
                return null;
            }
            return (byte[])this.getConnection().randomkey();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future)this.getAsyncConnection().rename((Object)oldName, (Object)newName)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().rename((Object)oldName, (Object)newName)));
                return;
            }
            this.getConnection().rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().renamenx((Object)oldName, (Object)newName)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().renamenx((Object)oldName, (Object)newName)));
                return null;
            }
            return this.getConnection().renamenx((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().ttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().ttl((Object)key)));
                return null;
            }
            return this.getConnection().ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().ttl((Object)key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().ttl((Object)key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.secondsToTimeUnit(this.getConnection().ttl((Object)key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            return LettuceConverters.toDataType(this.getConnection().type((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    public Cursor<byte[]> scan() {
        return this.scan(0L, ScanOptions.NONE);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (LettuceKeyCommands.this.isQueueing() || LettuceKeyCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                io.lettuce.core.ScanCursor scanCursor = LettuceKeyCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceKeyCommands.this.connection.getScanArgs(options);
                KeyScanCursor keyScanCursor = LettuceKeyCommands.this.getConnection().scan(scanCursor, scanArgs);
                String nextCursorId = keyScanCursor.getCursor();
                List keys = keyScanCursor.getKeys();
                return new ScanIteration<byte[]>(Long.valueOf(nextCursorId), keys);
            }

            @Override
            protected void doClose() {
                LettuceKeyCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceConnection.LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceConnection.LettuceTxResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }
}

