/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisVersionUtil;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;

class JedisZSetCommands
implements RedisZSetCommands {
    private final JedisConnection connection;

    public JedisZSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("zAdd of multiple fields not supported in pipeline or transaction");
        }
        Map<byte[], Double> args = this.zAddArgs(tuples);
        try {
            return this.connection.getJedis().zadd(key, args);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zcard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zcard(key)));
                return null;
            }
            return this.connection.getJedis().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zcount(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zcount(key, min, max)));
                return null;
            }
            return this.connection.getJedis().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("ZCOUNT not implemented in jedis for binary protocol on transaction and pipeline");
        }
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.getJedis().zcount(key, min, max);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zincrby(key, increment, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zincrby(key, increment, value)));
                return null;
            }
            return this.connection.getJedis().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zinterstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zinterstore(destKey, zparams, sets)));
                return null;
            }
            return this.connection.getJedis().zinterstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zinterstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zinterstore(destKey, sets)));
                return null;
            }
            return this.connection.getJedis().zinterstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrange(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYLEX.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByLex(key, min, max)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByLex(key, min, max)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrangeByLex(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScore(key, min, max)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScore(key, min, max)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getJedis().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrangeByScore(key, max, min)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrangeByScore(key, max, min)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrank(key, value)));
                return null;
            }
            return this.connection.getJedis().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrem(key, values)));
                return null;
            }
            return this.connection.getJedis().zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zremrangeByRank(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zremrangeByRank(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zremrangeByRank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREMRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zremrangeByScore(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zremrangeByScore(key, min, max)));
                return null;
            }
            return this.connection.getJedis().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrange(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zrevrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrevrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrevrank(key, value)));
                return null;
            }
            return this.connection.getJedis().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zscore(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zscore(key, value)));
                return null;
            }
            return this.connection.getJedis().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zunionstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zunionstore(destKey, zparams, sets)));
                return null;
            }
            return this.connection.getJedis().zunionstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zunionstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zunionstore(destKey, sets)));
                return null;
            }
            return this.connection.getJedis().zunionstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, Long cursorId, ScanOptions options) {
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId.longValue(), options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisZSetCommands.this.isQueueing() || JedisZSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisZSetCommands.this.connection.getJedis().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        try {
            String keyStr = new String(key, "UTF-8");
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScore(keyStr, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScore(keyStr, min, max)));
                return null;
            }
            return JedisConverters.stringSetToByteSet().convert(this.connection.getJedis().zrangeByScore(keyStr, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset and count must be less than Integer.MAX_VALUE for zRangeByScore in Jedis.");
        }
        try {
            String keyStr = new String(key, "UTF-8");
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().zrangeByScore(keyStr, min, max, (int)offset, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().zrangeByScore(keyStr, min, max, (int)offset, (int)count)));
                return null;
            }
            return JedisConverters.stringSetToByteSet().convert(this.connection.getJedis().zrangeByScore(keyStr, min, max, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private Map<byte[], Double> zAddArgs(Set<RedisZSetCommands.Tuple> tuples) {
        LinkedHashMap<byte[], Double> args = new LinkedHashMap<byte[], Double>(tuples.size(), 1.0f);
        HashSet<Double> scores = new HashSet<Double>(tuples.size(), 1.0f);
        boolean isAtLeastJedis24 = JedisVersionUtil.atLeastJedis24();
        for (RedisZSetCommands.Tuple tuple : tuples) {
            if (!isAtLeastJedis24) {
                if (scores.contains(tuple.getScore())) {
                    throw new UnsupportedOperationException("Bulk add of multiple elements with the same score is not supported. Add the elements individually.");
                }
                scores.add(tuple.getScore());
            }
            args.put(tuple.getValue(), tuple.getScore());
        }
        return args;
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

