/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisSetCommands
implements RedisSetCommands {
    private final JedisConnection connection;

    public JedisSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sadd(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sadd(key, values)));
                return null;
            }
            return this.connection.getJedis().sadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().scard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().scard(key)));
                return null;
            }
            return this.connection.getJedis().scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sdiff(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sdiff(keys)));
                return null;
            }
            return this.connection.getJedis().sdiff(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sdiffstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sdiffstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sdiffstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sinter(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sinter(keys)));
                return null;
            }
            return this.connection.getJedis().sinter(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sinterstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sinterstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sinterstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sismember(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sismember(key, value)));
                return null;
            }
            return this.connection.getJedis().sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().smembers(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().smembers(key)));
                return null;
            }
            return this.connection.getJedis().smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().smove(srcKey, destKey, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().spop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().spop(key)));
                return null;
            }
            return this.connection.getJedis().spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().srandmember(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().srandmember(key)));
                return null;
            }
            return this.connection.getJedis().srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count must be less than Integer.MAX_VALUE for sRandMember in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().srandmember(key, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().srandmember(key, (int)count)));
                return null;
            }
            return this.connection.getJedis().srandmember(key, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().srem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().srem(key, values)));
                return null;
            }
            return this.connection.getJedis().srem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sunion(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sunion(keys)));
                return null;
            }
            return this.connection.getJedis().sunion(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sunionstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sunionstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sunionstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisSetCommands.this.isQueueing() || JedisSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisSetCommands.this.connection.getJedis().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

