/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import redis.clients.jedis.Protocol;

class JedisListCommands
implements RedisListCommands {
    private final JedisConnection connection;

    public JedisListCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().rpush(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().rpush(key, values)));
                return null;
            }
            return this.connection.getJedis().rpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lpush(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lpush(key, values)));
                return null;
            }
            return this.connection.getJedis().lpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().rpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().rpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            return this.connection.getJedis().rpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            return this.connection.getJedis().lpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().llen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().llen(key)));
                return null;
            }
            return this.connection.getJedis().llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lrange(key, start, end)));
                return null;
            }
            return this.connection.getJedis().lrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().ltrim(key, start, end)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().ltrim(key, start, end)));
                return;
            }
            this.connection.getJedis().ltrim(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lindex(key, index)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lindex(key, index)));
                return null;
            }
            return this.connection.getJedis().lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().linsert(key, JedisConverters.toListPosition(where), pivot, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().linsert(key, JedisConverters.toListPosition(where), pivot, value)));
                return null;
            }
            return this.connection.getJedis().linsert(key, JedisConverters.toListPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().lset(key, index, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().lset(key, index, value)));
                return;
            }
            this.connection.getJedis().lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lrem(key, count, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lrem(key, count, value)));
                return null;
            }
            return this.connection.getJedis().lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().lpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().lpop(key)));
                return null;
            }
            return this.connection.getJedis().lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().rpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().rpop(key)));
                return null;
            }
            return this.connection.getJedis().rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().blpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().blpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            return this.connection.getJedis().blpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().brpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().brpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            return this.connection.getJedis().brpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().rpoplpush(srcKey, dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().rpoplpush(srcKey, dstKey)));
                return null;
            }
            return this.connection.getJedis().rpoplpush(srcKey, dstKey);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().brpoplpush(srcKey, dstKey, timeout)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().brpoplpush(srcKey, dstKey, timeout)));
                return null;
            }
            return this.connection.getJedis().brpoplpush(srcKey, dstKey, timeout);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private byte[][] bXPopArgs(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray((int)timeout));
        return (byte[][])args.toArray((T[])new byte[args.size()][]);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

