/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class JedisClusterStringCommands
implements RedisStringCommands {
    private final JedisClusterConnection connection;

    public JedisClusterStringCommands(JedisClusterConnection jedisClusterConnection) {
        this.connection = jedisClusterConnection;
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.connection.getCluster().get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return this.connection.getCluster().mget(keys);
        }
        return this.connection.getClusterCommandExecutor().executeMuliKeyCommand((client, key) -> client.get(key), Arrays.asList(keys)).resultsAsListSortBy(keys);
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            this.connection.getCluster().set(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null || expiration.isPersistent()) {
            if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
                this.set(key, value);
            } else {
                if (ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.SET_IF_PRESENT), (Object)((Object)option))) {
                    throw new UnsupportedOperationException("Jedis does not support SET XX without PX or EX on BinaryCluster.");
                }
                this.setNX(key, value);
            }
        } else if (option == null || ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                this.pSetEx(key, expiration.getExpirationTime(), value);
            } else {
                this.setEx(key, expiration.getExpirationTime(), value);
            }
        } else {
            byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
            byte[] expx = JedisConverters.toSetCommandExPxArgument(expiration);
            try {
                this.connection.getCluster().set(key, value, nxxx, expx, expiration.getExpirationTime());
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Seconds have cannot exceed Integer.MAX_VALUE!");
        }
        try {
            this.connection.getCluster().setex(key, Long.valueOf(seconds).intValue(), value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        if (milliseconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Milliseconds have cannot exceed Integer.MAX_VALUE!");
        }
        this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.psetex(key, milliseconds, value), this.connection.getTopologyProvider().getTopology().getKeyServingMasterNode(key));
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                this.connection.getCluster().mset(JedisConverters.toByteArrays(tuples));
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuple must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            try {
                return JedisConverters.toBoolean(this.connection.getCluster().msetnx(JedisConverters.toByteArrays(tuples)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }

    @Override
    public Long incr(byte[] key) {
        try {
            return this.connection.getCluster().incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            return this.connection.getCluster().incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            return this.connection.getCluster().incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            return this.connection.getCluster().decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            return this.connection.getCluster().decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            return this.connection.getCluster().append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().getrange(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        try {
            this.connection.getCluster().setrange(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            return this.connection.getCluster().getbit(key, offset);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            return this.connection.getCluster().setbit(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            return this.connection.getCluster().bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            return this.connection.getCluster().bitcount(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destination, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().bitop(JedisConverters.toBitOp(op), destination, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("BITOP is only supported for same slot keys in cluster mode.");
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            return this.connection.getCluster().strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

