/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.util.Assert;

public interface ReactiveRedisConnection
extends Closeable {
    @Override
    public void close();

    public ReactiveKeyCommands keyCommands();

    public ReactiveStringCommands stringCommands();

    public ReactiveNumberCommands numberCommands();

    public ReactiveListCommands listCommands();

    public ReactiveSetCommands setCommands();

    public ReactiveZSetCommands zSetCommands();

    public ReactiveHashCommands hashCommands();

    public ReactiveGeoCommands geoCommands();

    public ReactiveHyperLogLogCommands hyperLogLogCommands();

    public static class NumericResponse<I, O extends Number>
    extends CommandResponse<I, O> {
        public NumericResponse(I input, O output) {
            super(input, output);
        }
    }

    public static class MultiValueResponse<I, O>
    extends CommandResponse<I, List<O>> {
        public MultiValueResponse(I input, List<O> output) {
            super(input, output);
        }
    }

    public static class ByteBufferResponse<I>
    extends CommandResponse<I, ByteBuffer> {
        public ByteBufferResponse(I input, ByteBuffer output) {
            super(input, output);
        }
    }

    public static class BooleanResponse<I>
    extends CommandResponse<I, Boolean> {
        public BooleanResponse(I input, Boolean output) {
            super(input, output);
        }
    }

    public static class CommandResponse<I, O> {
        private final I input;
        private final O output;

        @ConstructorProperties(value={"input", "output"})
        public CommandResponse(I input, O output) {
            this.input = input;
            this.output = output;
        }

        public I getInput() {
            return this.input;
        }

        public O getOutput() {
            return this.output;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandResponse)) {
                return false;
            }
            CommandResponse other = (CommandResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            I this$input = this.getInput();
            I other$input = other.getInput();
            if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
                return false;
            }
            O this$output = this.getOutput();
            O other$output = other.getOutput();
            return !(this$output == null ? other$output != null : !this$output.equals(other$output));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            I $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            O $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            return result;
        }

        public String toString() {
            return "ReactiveRedisConnection.CommandResponse(input=" + this.getInput() + ", output=" + this.getOutput() + ")";
        }
    }

    public static class RangeCommand
    extends KeyCommand {
        Range<Long> range;

        private RangeCommand(ByteBuffer key, Range<Long> range) {
            super(key);
            this.range = range != null ? range : new Range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE));
        }

        public static RangeCommand key(ByteBuffer key) {
            return new RangeCommand(key, null);
        }

        public RangeCommand within(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new RangeCommand(this.getKey(), range);
        }

        public RangeCommand fromIndex(long start) {
            return new RangeCommand(this.getKey(), (Range<Long>)Range.of((Range.Bound)Range.Bound.inclusive((long)start), (Range.Bound)this.range.getUpperBound()));
        }

        public RangeCommand toIndex(long end) {
            return new RangeCommand(this.getKey(), (Range<Long>)Range.of((Range.Bound)this.range.getLowerBound(), (Range.Bound)Range.Bound.inclusive((long)end)));
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class KeyCommand
    implements Command {
        private ByteBuffer key;

        public KeyCommand(ByteBuffer key) {
            this.key = key;
        }

        @Override
        public ByteBuffer getKey() {
            return this.key;
        }
    }

    public static interface Command {
        public ByteBuffer getKey();

        default public String getName() {
            return this.getClass().getSimpleName().replace("Command", "").toUpperCase();
        }
    }
}

