/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveHashCommands {
    default public Mono<Boolean> hSet(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hSetNX(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key).ifValueNotExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hMSet(ByteBuffer key, Map<ByteBuffer, ByteBuffer> fieldValueMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(fieldValueMap, (String)"Field must not be null!");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.fieldValues(fieldValueMap).forKey(key).ifValueNotExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HSetCommand>> hSet(Publisher<HSetCommand> var1);

    default public Mono<ByteBuffer> hGet(ByteBuffer key, ByteBuffer field) {
        return this.hMGet(key, Collections.singletonList(field)).map(val -> val.isEmpty() ? null : (ByteBuffer)val.iterator().next());
    }

    default public Mono<List<ByteBuffer>> hMGet(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(fields, (String)"Fields must not be null!");
        return this.hMGet((Publisher<HGetCommand>)Mono.just((Object)HGetCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<HGetCommand, ByteBuffer>> hMGet(Publisher<HGetCommand> var1);

    default public Mono<Boolean> hExists(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        return this.hExists((Publisher<HExistsCommand>)Mono.just((Object)HExistsCommand.field(field).in(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HExistsCommand>> hExists(Publisher<HExistsCommand> var1);

    default public Mono<Boolean> hDel(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)field, (String)"Field must not be null!");
        return this.hDel(key, Collections.singletonList(field)).map(val -> val > 0L ? Boolean.TRUE : Boolean.FALSE);
    }

    default public Mono<Long> hDel(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(fields, (String)"Fields must not be null!");
        return this.hDel((Publisher<HDelCommand>)Mono.just((Object)HDelCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HDelCommand, Long>> hDel(Publisher<HDelCommand> var1);

    default public Mono<Long> hLen(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.hLen((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<List<ByteBuffer>> hKeys(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.hKeys((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveRedisConnection.KeyCommand, ByteBuffer>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<List<ByteBuffer>> hVals(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.hVals((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveRedisConnection.KeyCommand, ByteBuffer>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Map<ByteBuffer, ByteBuffer>> hGetAll(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.hGetAll((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Map<ByteBuffer, ByteBuffer>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    public static class HDelCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> fields;

        private HDelCommand(ByteBuffer key, List<ByteBuffer> fields) {
            super(key);
            this.fields = fields;
        }

        public static HDelCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return new HDelCommand(null, Collections.singletonList(field));
        }

        public static HDelCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, (String)"Fields must not be null!");
            return new HDelCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HDelCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new HDelCommand(key, this.fields);
        }

        public List<ByteBuffer> getFields() {
            return this.fields;
        }
    }

    public static class HExistsCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer field;

        private HExistsCommand(ByteBuffer key, ByteBuffer field) {
            super(key);
            this.field = field;
        }

        public static HExistsCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return new HExistsCommand(null, field);
        }

        public HExistsCommand in(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new HExistsCommand(key, this.field);
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }

    public static class HGetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private List<ByteBuffer> fields;

        private HGetCommand(ByteBuffer key, List<ByteBuffer> fields) {
            super(key);
            this.fields = fields;
        }

        public static HGetCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return new HGetCommand(null, Collections.singletonList(field));
        }

        public static HGetCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, (String)"Fields must not be null!");
            return new HGetCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HGetCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new HGetCommand(key, this.fields);
        }

        public List<ByteBuffer> getFields() {
            return this.fields;
        }
    }

    public static class HSetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private static final ByteBuffer SINGLE_VALUE_KEY = ByteBuffer.allocate(0);
        private final Map<ByteBuffer, ByteBuffer> fieldValueMap;
        private final boolean upsert;

        private HSetCommand(ByteBuffer key, Map<ByteBuffer, ByteBuffer> keyValueMap, boolean upsert) {
            super(key);
            this.fieldValueMap = keyValueMap;
            this.upsert = upsert;
        }

        public static HSetCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new HSetCommand(null, Collections.singletonMap(SINGLE_VALUE_KEY, value), Boolean.TRUE);
        }

        public static HSetCommand fieldValues(Map<ByteBuffer, ByteBuffer> fieldValueMap) {
            Assert.notNull(fieldValueMap, (String)"Field values map must not be null!");
            return new HSetCommand(null, fieldValueMap, Boolean.TRUE);
        }

        public HSetCommand ofField(ByteBuffer field) {
            if (!this.fieldValueMap.containsKey(SINGLE_VALUE_KEY)) {
                throw new InvalidDataAccessApiUsageException("Value has not been set.");
            }
            Assert.notNull((Object)field, (String)"Field not be null!");
            return new HSetCommand(this.getKey(), Collections.singletonMap(field, this.fieldValueMap.get(SINGLE_VALUE_KEY)), this.upsert);
        }

        public HSetCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key not be null!");
            return new HSetCommand(key, this.fieldValueMap, this.upsert);
        }

        public HSetCommand ifValueNotExists() {
            return new HSetCommand(this.getKey(), this.fieldValueMap, Boolean.FALSE);
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public Map<ByteBuffer, ByteBuffer> getFieldValueMap() {
            return this.fieldValueMap;
        }
    }
}

