/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.cache.DefaultRedisCachePrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCachePrefix;
import org.springframework.data.redis.core.RedisTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final Collection<String> names = Collections.unmodifiableSet(this.caches.keySet());
    private final RedisTemplate template;
    private boolean usePrefix;
    private RedisCachePrefix cachePrefix = new DefaultRedisCachePrefix();

    public RedisCacheManager(RedisTemplate template) {
        this.template = template;
    }

    public Cache getCache(String name) {
        Cache c = (Cache)this.caches.get(name);
        if (c == null) {
            c = new RedisCache(name, this.usePrefix ? this.cachePrefix.prefix(name) : null, this.template);
            this.caches.put(name, c);
            this.names.add(name);
        }
        return c;
    }

    public Collection<String> getCacheNames() {
        return this.names;
    }

    public void setCachePrefix(RedisCachePrefix cachePrefix) {
        this.cachePrefix = cachePrefix;
    }
}

