/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import io.r2dbc.spi.Statement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.function.BindIdOperation;
import org.springframework.data.r2dbc.function.BindableOperation;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.function.convert.SettableValue;
import org.springframework.data.r2dbc.repository.support.BindSpecAdapter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.repository.reactive.ReactiveCrudRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleR2dbcRepository<T, ID>
implements ReactiveCrudRepository<T, ID> {
    @NonNull
    private final RelationalEntityInformation<T, ID> entity;
    @NonNull
    private final DatabaseClient databaseClient;
    @NonNull
    private final MappingR2dbcConverter converter;
    @NonNull
    private final ReactiveDataAccessStrategy accessStrategy;

    public <S extends T> Mono<S> save(S objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        if (this.entity.isNew(objectToSave)) {
            return this.databaseClient.insert().into(this.entity.getJavaType()).using(objectToSave).map(this.converter.populateIdIfNecessary(objectToSave)).one();
        }
        Object id = this.entity.getRequiredId(objectToSave);
        Map<String, SettableValue> columns = this.accessStrategy.getColumnsToUpdate(objectToSave);
        columns.remove(this.getIdColumnName());
        String idColumnName = this.getIdColumnName();
        BindIdOperation update = this.accessStrategy.updateById(this.entity.getTableName(), columns.keySet(), idColumnName);
        DatabaseClient.GenericExecuteSpec exec = this.databaseClient.execute().sql(update);
        BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(exec);
        columns.forEach(this.bind(update, wrapper));
        update.bindId(wrapper, id);
        return wrapper.getBoundOperation().as(this.entity.getJavaType()).then().thenReturn(objectToSave);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Objects to save must not be null!");
        return Flux.fromIterable(objectsToSave).concatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Object publisher must not be null!");
        return Flux.from(objectsToSave).concatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        LinkedHashSet<String> columns = new LinkedHashSet<String>(this.accessStrategy.getAllColumns(this.entity.getJavaType()));
        String idColumnName = this.getIdColumnName();
        BindIdOperation select = this.accessStrategy.selectById(this.entity.getTableName(), columns, idColumnName);
        DatabaseClient.GenericExecuteSpec sql = this.databaseClient.execute().sql(select);
        BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(sql);
        select.bindId(wrapper, id);
        return wrapper.getBoundOperation().as(this.entity.getJavaType()).fetch().one();
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        String idColumnName = this.getIdColumnName();
        BindIdOperation select = this.accessStrategy.selectById(this.entity.getTableName(), Collections.singleton(idColumnName), idColumnName, 10);
        DatabaseClient.GenericExecuteSpec sql = this.databaseClient.execute().sql(select);
        BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(sql);
        select.bindId(wrapper, id);
        return wrapper.getBoundOperation().as(this.entity.getJavaType()).map((r, md) -> r).first().hasElement();
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById).hasElement();
    }

    public Flux<T> findAll() {
        return this.databaseClient.select().from(this.entity.getJavaType()).fetch().all();
    }

    public Flux<T> findAllById(Iterable<ID> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(iterable));
    }

    public Flux<T> findAllById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            LinkedHashSet<String> columns = new LinkedHashSet<String>(this.accessStrategy.getAllColumns(this.entity.getJavaType()));
            String idColumnName = this.getIdColumnName();
            BindIdOperation select = this.accessStrategy.selectByIdIn(this.entity.getTableName(), columns, idColumnName);
            BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(this.databaseClient.execute().sql(select));
            select.bindIds((Statement<?>)wrapper, (Iterable<? extends Object>)ids);
            return wrapper.getBoundOperation().as(this.entity.getJavaType()).fetch().all();
        });
    }

    public Mono<Long> count() {
        return this.databaseClient.execute().sql(String.format("SELECT COUNT(%s) FROM %s", this.getIdColumnName(), this.entity.getTableName())).map((r, md) -> (Long)r.get((Object)0, Long.class)).first().defaultIfEmpty((Object)0L);
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        BindIdOperation delete = this.accessStrategy.deleteById(this.entity.getTableName(), this.getIdColumnName());
        BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(this.databaseClient.execute().sql(delete));
        delete.bindId(wrapper, id);
        return wrapper.getBoundOperation().fetch().rowsUpdated().then();
    }

    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            String idColumnName = this.getIdColumnName();
            BindIdOperation delete = this.accessStrategy.deleteByIdIn(this.entity.getTableName(), idColumnName);
            BindSpecAdapter<DatabaseClient.GenericExecuteSpec> wrapper = BindSpecAdapter.create(this.databaseClient.execute().sql(delete));
            delete.bindIds((Statement<?>)wrapper, (Iterable<? extends Object>)ids);
            return wrapper.getBoundOperation().as(this.entity.getJavaType()).fetch().rowsUpdated();
        }).then();
    }

    public Mono<Void> delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        return this.deleteById(this.entity.getRequiredId(objectToDelete));
    }

    public Mono<Void> deleteAll(Iterable<? extends T> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(iterable));
    }

    public Mono<Void> deleteAll(Publisher<? extends T> objectPublisher) {
        Assert.notNull(objectPublisher, (String)"The Object Publisher must not be null!");
        Flux idPublisher = Flux.from(objectPublisher).map(arg_0 -> this.entity.getRequiredId(arg_0));
        return this.deleteById((Publisher<ID>)idPublisher);
    }

    public Mono<Void> deleteAll() {
        return this.databaseClient.execute().sql(String.format("DELETE FROM %s", this.entity.getTableName())).then();
    }

    private String getIdColumnName() {
        return ((RelationalPersistentProperty)((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty()).getColumnName();
    }

    private BiConsumer<String, SettableValue> bind(BindableOperation operation, Statement<?> statement) {
        return (k, v) -> operation.bind(statement, (SettableValue)v);
    }

    public SimpleR2dbcRepository(@NonNull RelationalEntityInformation<T, ID> entity, @NonNull DatabaseClient databaseClient, @NonNull MappingR2dbcConverter converter, @NonNull ReactiveDataAccessStrategy accessStrategy) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is marked @NonNull but is null");
        }
        if (databaseClient == null) {
            throw new IllegalArgumentException("databaseClient is marked @NonNull but is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is marked @NonNull but is null");
        }
        if (accessStrategy == null) {
            throw new IllegalArgumentException("accessStrategy is marked @NonNull but is null");
        }
        this.entity = entity;
        this.databaseClient = databaseClient;
        this.converter = converter;
        this.accessStrategy = accessStrategy;
    }
}

