/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.connectionfactory;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.r2dbc.function.connectionfactory.ReactiveTransactionSynchronization;
import org.springframework.data.r2dbc.function.connectionfactory.SingletonConnectionFactory;
import org.springframework.data.r2dbc.function.connectionfactory.TransactionResources;
import org.springframework.lang.Nullable;
import org.springframework.transaction.NoTransactionException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog(ConnectionFactoryUtils.class);

    public static Mono<Tuple2<Connection, ConnectionFactory>> getConnection(ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doGetConnection(connectionFactory).onErrorMap(e -> new DataAccessResourceFailureException("Failed to obtain R2DBC Connection", e));
    }

    public static Mono<Tuple2<Connection, ConnectionFactory>> doGetConnection(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return Mono.subscriberContext().flatMap(it -> {
            if (it.hasKey(ReactiveTransactionSynchronization.class)) {
                ReactiveTransactionSynchronization synchronization = (ReactiveTransactionSynchronization)it.get(ReactiveTransactionSynchronization.class);
                return ConnectionFactoryUtils.obtainConnection(synchronization, connectionFactory);
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> Mono.from((Publisher)connectionFactory.create()).map(it -> Tuples.of((Object)it, (Object)connectionFactory))));
    }

    private static Mono<Tuple2<Connection, ConnectionFactory>> obtainConnection(ReactiveTransactionSynchronization synchronization, ConnectionFactory connectionFactory) {
        if (synchronization.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for R2DBC Connection");
            TransactionResources txContext = synchronization.getCurrentTransaction();
            ConnectionFactory resource = txContext.getResource(ConnectionFactory.class);
            Mono attachNewConnection = Mono.defer(() -> Mono.from((Publisher)connectionFactory.create()).map(it -> {
                logger.debug((Object)"Fetching new R2DBC Connection from ConnectionFactory");
                SingletonConnectionFactory s = new SingletonConnectionFactory(connectionFactory.getMetadata(), (Connection)it);
                txContext.registerResource(ConnectionFactory.class, s);
                return Tuples.of((Object)it, (Object)connectionFactory);
            }));
            return Mono.justOrEmpty((Object)resource).flatMap(factory -> {
                logger.debug((Object)"Fetching resumed R2DBC Connection from ConnectionFactory");
                return Mono.from((Publisher)factory.create()).map(connection -> Tuples.of((Object)connection, (Object)factory));
            }).switchIfEmpty(attachNewConnection);
        }
        return Mono.empty();
    }

    public static Mono<Void> releaseConnection(@Nullable Connection con, @Nullable ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doReleaseConnection(con, connectionFactory).onErrorMap(e -> new DataAccessResourceFailureException("Failed to close R2DBC Connection", e));
    }

    public static Mono<Void> doReleaseConnection(@Nullable Connection con, @Nullable ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof SingletonConnectionFactory) {
            SingletonConnectionFactory factory = (SingletonConnectionFactory)connectionFactory;
            logger.debug((Object)"Releasing R2DBC Connection");
            return factory.close(con);
        }
        logger.debug((Object)"Closing R2DBC Connection");
        return Mono.from((Publisher)con.close());
    }

    public static Mono<Void> closeConnection(Connection connection, ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doCloseConnection(connection, connectionFactory).onErrorMap(e -> new DataAccessResourceFailureException("Failed to obtain R2DBC Connection", e));
    }

    public static Mono<Void> doCloseConnection(Connection connection, @Nullable ConnectionFactory connectionFactory) {
        if (!(connectionFactory instanceof SingletonConnectionFactory) || ((SingletonConnectionFactory)connectionFactory).shouldClose(connection)) {
            SingletonConnectionFactory factory = (SingletonConnectionFactory)connectionFactory;
            return factory.close(connection).then(Mono.from((Publisher)connection.close()));
        }
        return Mono.empty();
    }

    public static Mono<ReactiveTransactionSynchronization> currentReactiveTransactionSynchronization() {
        return Mono.subscriberContext().filter(it -> it.hasKey(ReactiveTransactionSynchronization.class)).switchIfEmpty(Mono.error((Throwable)new NoTransactionException("Transaction management is not enabled. Make sure to register ReactiveTransactionSynchronization in the subscriber Context!"))).map(it -> (ReactiveTransactionSynchronization)it.get(ReactiveTransactionSynchronization.class));
    }

    public static Mono<ReactiveTransactionSynchronization> currentActiveReactiveTransactionSynchronization() {
        return ConnectionFactoryUtils.currentReactiveTransactionSynchronization().filter(ReactiveTransactionSynchronization::isSynchronizationActive).switchIfEmpty(Mono.error((Throwable)new NoTransactionException("ReactiveTransactionSynchronization not active!")));
    }

    public static Mono<ConnectionFactory> currentConnectionFactory() {
        return ConnectionFactoryUtils.currentActiveReactiveTransactionSynchronization().map(synchronization -> {
            TransactionResources currentSynchronization = synchronization.getCurrentTransaction();
            return currentSynchronization.getResource(ConnectionFactory.class);
        }).switchIfEmpty(Mono.error((Throwable)new DataAccessResourceFailureException("Cannot extract ConnectionFactory from current TransactionContext!")));
    }
}

