/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function;

import io.r2dbc.spi.ConnectionFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.DefaultTransactionalDatabaseClient;
import org.springframework.data.r2dbc.function.DefaultTransactionalDatabaseClientBuilder;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface TransactionalDatabaseClient
extends DatabaseClient {
    public Mono<Void> beginTransaction();

    public Mono<Void> commitTransaction();

    public Mono<Void> rollbackTransaction();

    public <T> Flux<T> inTransaction(Function<DatabaseClient, ? extends Publisher<? extends T>> var1);

    default public <T> Mono<T> enableTransactionSynchronization(Mono<T> publisher) {
        Assert.notNull(publisher, (String)"Publisher must not be null!");
        return publisher.subscriberContext(DefaultTransactionalDatabaseClient::withTransactionSynchronization);
    }

    default public <T> Flux<T> enableTransactionSynchronization(Publisher<T> publisher) {
        Assert.notNull(publisher, (String)"Publisher must not be null!");
        return Flux.from(publisher).subscriberContext(DefaultTransactionalDatabaseClient::withTransactionSynchronization);
    }

    @Override
    public Builder mutate();

    public static TransactionalDatabaseClient create(ConnectionFactory factory) {
        return new DefaultTransactionalDatabaseClientBuilder().connectionFactory(factory).build();
    }

    public static Builder builder() {
        return new DefaultTransactionalDatabaseClientBuilder();
    }

    public static interface Builder
    extends DatabaseClient.Builder {
        @Override
        public Builder connectionFactory(ConnectionFactory var1);

        @Override
        public Builder exceptionTranslator(R2dbcExceptionTranslator var1);

        @Override
        public Builder dataAccessStrategy(ReactiveDataAccessStrategy var1);

        @Override
        public Builder apply(Consumer<DatabaseClient.Builder> var1);

        @Override
        public TransactionalDatabaseClient build();
    }
}

