/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.UncategorizedR2dbcException;
import org.springframework.data.r2dbc.function.BindableOperation;
import org.springframework.data.r2dbc.function.ConnectionAccessor;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.function.DefaultSqlResult;
import org.springframework.data.r2dbc.function.FetchSpec;
import org.springframework.data.r2dbc.function.QueryOperation;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.function.convert.ColumnMapRowMapper;
import org.springframework.data.r2dbc.function.convert.SettableValue;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultDatabaseClient
implements DatabaseClient,
ConnectionAccessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConnectionFactory connector;
    private final R2dbcExceptionTranslator exceptionTranslator;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final DefaultDatabaseClientBuilder builder;

    DefaultDatabaseClient(ConnectionFactory connector, R2dbcExceptionTranslator exceptionTranslator, ReactiveDataAccessStrategy dataAccessStrategy, DefaultDatabaseClientBuilder builder) {
        this.connector = connector;
        this.exceptionTranslator = exceptionTranslator;
        this.dataAccessStrategy = dataAccessStrategy;
        this.builder = builder;
    }

    @Override
    public DatabaseClient.Builder mutate() {
        return this.builder;
    }

    @Override
    public DatabaseClient.SqlSpec execute() {
        return new DefaultSqlSpec();
    }

    @Override
    public DatabaseClient.SelectFromSpec select() {
        return new DefaultSelectFromSpec();
    }

    @Override
    public DatabaseClient.InsertIntoSpec insert() {
        return new DefaultInsertIntoSpec();
    }

    @Override
    public <T> Mono<T> inConnection(Function<Connection, Mono<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono<Connection> connectionMono = this.getConnection();
        return Mono.usingWhen(connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy((Connection)it);
            return DefaultDatabaseClient.doInConnection(connectionToUse, action);
        }, this::closeConnection, this::closeConnection, this::closeConnection).onErrorMap(R2dbcException.class, ex -> this.translateException("execute", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    @Override
    public <T> Flux<T> inConnectionMany(Function<Connection, Flux<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono<Connection> connectionMono = this.getConnection();
        return Flux.usingWhen(connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy((Connection)it);
            return DefaultDatabaseClient.doInConnectionMany(connectionToUse, action);
        }, this::closeConnection, this::closeConnection, this::closeConnection).onErrorMap(R2dbcException.class, ex -> this.translateException("executeMany", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    protected Mono<Connection> getConnection() {
        return Mono.from((Publisher)this.obtainConnectionFactory().create());
    }

    protected Publisher<Void> closeConnection(Connection connection) {
        return connection.close();
    }

    protected ConnectionFactory obtainConnectionFactory() {
        return this.connector;
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    protected DataAccessException translateException(String task, @Nullable String sql, R2dbcException ex) {
        DataAccessException dae = this.exceptionTranslator.translate(task, sql, ex);
        return dae != null ? dae : new UncategorizedR2dbcException(task, sql, ex);
    }

    protected <T> DefaultTypedExecuteSpec<T> createTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, Class<T> typeToRead) {
        return new DefaultTypedExecuteSpec<T>(byIndex, byName, sqlSupplier, typeToRead);
    }

    protected <T> DefaultTypedExecuteSpec<T> createTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
        return new DefaultTypedExecuteSpec<T>(byIndex, byName, sqlSupplier, mappingFunction);
    }

    protected ExecuteSpecSupport createGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
        return new DefaultGenericExecuteSpec(byIndex, byName, sqlSupplier);
    }

    protected DefaultGenericExecuteSpec createGenericExecuteSpec(Supplier<String> sqlSupplier) {
        return new DefaultGenericExecuteSpec(sqlSupplier);
    }

    private static void doBind(Statement<?> statement, Map<String, SettableValue> byName, Map<Integer, SettableValue> byIndex) {
        byIndex.forEach((i, o) -> {
            if (o.getValue() != null) {
                statement.bind(i.intValue(), o.getValue());
            } else {
                statement.bindNull(i.intValue(), o.getType());
            }
        });
        byName.forEach((name, o) -> {
            if (o.getValue() != null) {
                statement.bind(name, o.getValue());
            } else {
                statement.bindNull(name, o.getType());
            }
        });
    }

    private static <T> Flux<T> doInConnectionMany(Connection connection, Function<Connection, Flux<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Flux.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnectionMany", sql, e){}));
        }
    }

    private static <T> Mono<T> doInConnection(Connection connection, Function<Connection, Mono<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Mono.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnection", sql, e){}));
        }
    }

    @Nullable
    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return proxy;
                }
            } else if (method.getName().equals("isWrapperFor")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return true;
                }
            } else {
                if (method.getName().equals("close")) {
                    return Mono.error((Throwable)new UnsupportedOperationException("Close is not supported!"));
                }
                if (method.getName().equals("getTargetConnection")) {
                    return this.target;
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    class DefaultTypedInsertSpec<T, R>
    implements DatabaseClient.TypedInsertSpec<T>,
    DatabaseClient.InsertSpec<R> {
        private final Class<?> typeToInsert;
        private final String table;
        private final Publisher<T> objectToInsert;
        private final BiFunction<Row, RowMetadata, R> mappingFunction;

        DefaultTypedInsertSpec(Class<?> typeToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToInsert);
            this.objectToInsert = Mono.empty();
            this.mappingFunction = mappingFunction;
        }

        @Override
        public DatabaseClient.TypedInsertSpec<T> table(String tableName) {
            Assert.hasText((String)tableName, (String)"Table name must not be null or empty!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, tableName, this.objectToInsert, this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(T objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Object to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, Mono.just(objectToInsert), this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(Publisher<T> objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Publisher to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, objectToInsert, this.mappingFunction);
        }

        @Override
        public <MR> FetchSpec<MR> map(BiFunction<Row, RowMetadata, MR> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<R> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return Mono.from(this.objectToInsert).flatMapMany(toInsert -> this.exchange(toInsert, (row, md) -> row).all()).then();
        }

        private <MR> FetchSpec<MR> exchange(final BiFunction<Row, RowMetadata, MR> mappingFunction) {
            return new FetchSpec<MR>(){

                @Override
                public Mono<MR> one() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).one());
                }

                @Override
                public Mono<MR> first() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).first());
                }

                @Override
                public Flux<MR> all() {
                    return Flux.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).all());
                }

                @Override
                public Mono<Integer> rowsUpdated() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMapMany(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).rowsUpdated()).collect(Collectors.summingInt(Integer::intValue));
                }
            };
        }

        private <MR> FetchSpec<MR> exchange(Object toInsert, BiFunction<Row, RowMetadata, MR> mappingFunction) {
            List<SettableValue> insertValues = DefaultDatabaseClient.this.dataAccessStrategy.getValuesToInsert(toInsert);
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            for (SettableValue insertValue : insertValues) {
                columns.add(insertValue.getIdentifier().toString());
            }
            BindableOperation bindableInsert = DefaultDatabaseClient.this.dataAccessStrategy.insertAndReturnGeneratedKeys(this.table, columns);
            String sql = bindableInsert.toQuery();
            Function<Connection, Statement> insertFunction = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                Statement statement = it.createStatement(sql);
                for (SettableValue settable : insertValues) {
                    bindableInsert.bind(statement, settable);
                }
                return statement;
            };
            Function<Connection, Flux<Result>> resultFunction = it -> Flux.from((Publisher)((Statement)insertFunction.apply((Connection)it)).execute());
            return new DefaultSqlResult<MR>(DefaultDatabaseClient.this, sql, resultFunction, it -> ((Flux)resultFunction.apply((Connection)it)).flatMap(Result::getRowsUpdated).collect(Collectors.summingInt(Integer::intValue)), mappingFunction);
        }

        public DefaultTypedInsertSpec(Class<?> typeToInsert, String table, Publisher<T> objectToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = table;
            this.objectToInsert = objectToInsert;
            this.mappingFunction = mappingFunction;
        }
    }

    class DefaultGenericInsertSpec<T>
    implements DatabaseClient.GenericInsertSpec<T> {
        private final String table;
        private final Map<String, SettableValue> byName;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        @Override
        public DatabaseClient.GenericInsertSpec value(String field, Object value) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(field, new SettableValue(field, value, null));
            return new DefaultGenericInsertSpec<T>(this.table, byName, this.mappingFunction);
        }

        @Override
        public DatabaseClient.GenericInsertSpec nullValue(String field, Class<?> type) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(field, new SettableValue(field, null, type));
            return new DefaultGenericInsertSpec<T>(this.table, byName, this.mappingFunction);
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            if (this.byName.isEmpty()) {
                throw new IllegalStateException("Insert fields is empty!");
            }
            BindableOperation bindableInsert = DefaultDatabaseClient.this.dataAccessStrategy.insertAndReturnGeneratedKeys(this.table, this.byName.keySet());
            String sql = bindableInsert.toQuery();
            Function<Connection, Statement> insertFunction = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                Statement statement = it.createStatement(sql);
                this.byName.forEach((k, v) -> bindableInsert.bind((Statement<?>)statement, (SettableValue)v));
                return statement;
            };
            Function<Connection, Flux<Result>> resultFunction = it -> Flux.from((Publisher)((Statement)insertFunction.apply((Connection)it)).execute());
            return new DefaultSqlResult<R>(DefaultDatabaseClient.this, sql, resultFunction, it -> ((Flux)resultFunction.apply((Connection)it)).flatMap(Result::getRowsUpdated).next(), mappingFunction);
        }

        public DefaultGenericInsertSpec(String table, Map<String, SettableValue> byName, BiFunction<Row, RowMetadata, T> mappingFunction) {
            this.table = table;
            this.byName = byName;
            this.mappingFunction = mappingFunction;
        }
    }

    class DefaultInsertIntoSpec
    implements DatabaseClient.InsertIntoSpec {
        DefaultInsertIntoSpec() {
        }

        @Override
        public DatabaseClient.GenericInsertSpec<Map<String, Object>> into(String table) {
            return new DefaultGenericInsertSpec<Map<String, Object>>(table, Collections.emptyMap(), ColumnMapRowMapper.INSTANCE);
        }

        @Override
        public <T> DatabaseClient.TypedInsertSpec<T> into(Class<T> table) {
            return new DefaultTypedInsertSpec(table, ColumnMapRowMapper.INSTANCE);
        }
    }

    private class DefaultTypedSelectSpec<T>
    extends DefaultSelectSpecSupport
    implements DatabaseClient.TypedSelectSpec<T> {
        @Nullable
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedSelectSpec(Class<T> typeToRead) {
            super(DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToRead));
            this.typeToRead = typeToRead;
            this.mappingFunction = DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        DefaultTypedSelectSpec(String table, List<String> projectedFields, Sort sort, Pageable page, BiFunction<Row, RowMetadata, T> mappingFunction) {
            this(table, projectedFields, sort, page, null, mappingFunction);
        }

        DefaultTypedSelectSpec(String table, List<String> projectedFields, Sort sort, Pageable page, Class<T> typeToRead, BiFunction<Row, RowMetadata, T> mappingFunction) {
            super(table, projectedFields, sort, page);
            this.typeToRead = typeToRead;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public <R> FetchSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return this.exchange(DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultTypedSelectSpec<T> project(String ... selectedFields) {
            return (DefaultTypedSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultTypedSelectSpec<T> orderBy(Sort sort) {
            return (DefaultTypedSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultTypedSelectSpec<T> page(Pageable page) {
            return (DefaultTypedSelectSpec)super.page(page);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            List<String> columns = this.projectedFields.isEmpty() ? DefaultDatabaseClient.this.dataAccessStrategy.getAllColumns(this.typeToRead) : this.projectedFields;
            Sort sortToUse = this.sort.isSorted() ? DefaultDatabaseClient.this.dataAccessStrategy.getMappedSort(this.typeToRead, this.sort) : Sort.unsorted();
            QueryOperation select = DefaultDatabaseClient.this.dataAccessStrategy.select(this.table, new LinkedHashSet<String>(columns), sortToUse, this.page);
            return this.execute(select.get(), mappingFunction);
        }

        @Override
        protected DefaultTypedSelectSpec<T> createInstance(String table, List<String> projectedFields, Sort sort, Pageable page) {
            return new DefaultTypedSelectSpec<T>(table, projectedFields, sort, page, this.typeToRead, this.mappingFunction);
        }
    }

    private class DefaultGenericSelectSpec
    extends DefaultSelectSpecSupport
    implements DatabaseClient.GenericSelectSpec {
        DefaultGenericSelectSpec(String table, List<String> projectedFields, Sort sort, Pageable page) {
            super(table, projectedFields, sort, page);
        }

        DefaultGenericSelectSpec(String table) {
            super(table);
        }

        @Override
        public <R> DatabaseClient.TypedSelectSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return new DefaultTypedSelectSpec<R>(this.table, this.projectedFields, this.sort, this.page, resultType, DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultGenericSelectSpec project(String ... selectedFields) {
            return (DefaultGenericSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultGenericSelectSpec orderBy(Sort sort) {
            return (DefaultGenericSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultGenericSelectSpec page(Pageable page) {
            return (DefaultGenericSelectSpec)super.page(page);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange(ColumnMapRowMapper.INSTANCE);
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Set<String> columns = this.projectedFields.isEmpty() ? Collections.singleton("*") : new LinkedHashSet<String>(this.projectedFields);
            QueryOperation select = DefaultDatabaseClient.this.dataAccessStrategy.select(this.table, columns, this.sort, this.page);
            return this.execute(select.toQuery(), mappingFunction);
        }

        @Override
        protected DefaultGenericSelectSpec createInstance(String table, List<String> projectedFields, Sort sort, Pageable page) {
            return new DefaultGenericSelectSpec(table, projectedFields, sort, page);
        }
    }

    private abstract class DefaultSelectSpecSupport {
        final String table;
        final List<String> projectedFields;
        final Sort sort;
        final Pageable page;

        DefaultSelectSpecSupport(String table) {
            Assert.hasText((String)table, (String)"Table name must not be null!");
            this.table = table;
            this.projectedFields = Collections.emptyList();
            this.sort = Sort.unsorted();
            this.page = Pageable.unpaged();
        }

        public DefaultSelectSpecSupport project(String ... selectedFields) {
            Assert.notNull((Object)selectedFields, (String)"Projection fields must not be null!");
            ArrayList<String> projectedFields = new ArrayList<String>(this.projectedFields.size() + selectedFields.length);
            projectedFields.addAll(this.projectedFields);
            projectedFields.addAll(Arrays.asList(selectedFields));
            return this.createInstance(this.table, projectedFields, this.sort, this.page);
        }

        public DefaultSelectSpecSupport orderBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null!");
            return this.createInstance(this.table, this.projectedFields, sort, this.page);
        }

        public DefaultSelectSpecSupport page(Pageable page) {
            Assert.notNull((Object)page, (String)"Pageable must not be null!");
            return this.createInstance(this.table, this.projectedFields, this.sort, page);
        }

        <R> FetchSpec<R> execute(String sql, BiFunction<Row, RowMetadata, R> mappingFunction) {
            Function<Connection, Statement> selectFunction = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                return it.createStatement(sql);
            };
            Function<Connection, Flux<Result>> resultFunction = it -> Flux.from((Publisher)((Statement)selectFunction.apply((Connection)it)).execute());
            return new DefaultSqlResult<R>(DefaultDatabaseClient.this, sql, resultFunction, it -> Mono.error((Throwable)new UnsupportedOperationException("Not available for SELECT")), mappingFunction);
        }

        protected abstract DefaultSelectSpecSupport createInstance(String var1, List<String> var2, Sort var3, Pageable var4);

        public DefaultSelectSpecSupport(String table, List<String> projectedFields, Sort sort, Pageable page) {
            this.table = table;
            this.projectedFields = projectedFields;
            this.sort = sort;
            this.page = page;
        }
    }

    class DefaultSelectFromSpec
    implements DatabaseClient.SelectFromSpec {
        DefaultSelectFromSpec() {
        }

        @Override
        public DatabaseClient.GenericSelectSpec from(String table) {
            return new DefaultGenericSelectSpec(table);
        }

        @Override
        public <T> DatabaseClient.TypedSelectSpec<T> from(Class<T> table) {
            return new DefaultTypedSelectSpec<T>(table);
        }
    }

    protected class DefaultTypedExecuteSpec<T>
    extends ExecuteSpecSupport
    implements DatabaseClient.TypedExecuteSpec<T> {
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, Class<T> typeToRead) {
            super(byIndex, byName, sqlSupplier);
            this.typeToRead = typeToRead;
            this.mappingFunction = DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        DefaultTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
            super(byIndex, byName, sqlSupplier);
            this.typeToRead = null;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec((Map<Integer, SettableValue>)this.byIndex, (Map<String, SettableValue>)this.byName, (Supplier<String>)this.sqlSupplier, resultType);
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.getSql(), mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.getSql(), this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(int index, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(int index, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(String name, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(String name, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(name, type);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(Object bean) {
            return (DefaultTypedExecuteSpec)super.bind(bean);
        }

        @Override
        protected DefaultTypedExecuteSpec<T> createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return DefaultDatabaseClient.this.createTypedExecuteSpec(byIndex, byName, sqlSupplier, this.typeToRead);
        }
    }

    protected class DefaultGenericExecuteSpec
    extends ExecuteSpecSupport
    implements DatabaseClient.GenericExecuteSpec {
        DefaultGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            super(byIndex, byName, sqlSupplier);
        }

        DefaultGenericExecuteSpec(Supplier<String> sqlSupplier) {
            super(sqlSupplier);
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec((Map<Integer, SettableValue>)this.byIndex, (Map<String, SettableValue>)this.byName, (Supplier<String>)this.sqlSupplier, resultType);
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.getSql(), mappingFunction);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange(this.getSql(), ColumnMapRowMapper.INSTANCE);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultGenericExecuteSpec bind(int index, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(int index, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultGenericExecuteSpec bind(String name, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(String name, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(name, type);
        }

        @Override
        public DefaultGenericExecuteSpec bind(Object bean) {
            return (DefaultGenericExecuteSpec)super.bind(bean);
        }

        @Override
        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return DefaultDatabaseClient.this.createGenericExecuteSpec(byIndex, byName, sqlSupplier);
        }
    }

    class ExecuteSpecSupport {
        final Map<Integer, SettableValue> byIndex;
        final Map<String, SettableValue> byName;
        final Supplier<String> sqlSupplier;

        ExecuteSpecSupport(Supplier<String> sqlSupplier) {
            this.byIndex = Collections.emptyMap();
            this.byName = Collections.emptyMap();
            this.sqlSupplier = sqlSupplier;
        }

        protected String getSql() {
            String sql = this.sqlSupplier.get();
            Assert.state((sql != null ? 1 : 0) != 0, (String)"SQL supplier returned null!");
            return sql;
        }

        <T> FetchSpec<T> exchange(String sql, BiFunction<Row, RowMetadata, T> mappingFunction) {
            Function<Connection, Statement> executeFunction = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                Statement statement = it.createStatement(sql);
                DefaultDatabaseClient.doBind(statement, this.byName, this.byIndex);
                return statement;
            };
            Function<Connection, Flux<Result>> resultFunction = it -> Flux.from((Publisher)((Statement)executeFunction.apply((Connection)it)).execute());
            return new DefaultSqlResult<T>(DefaultDatabaseClient.this, sql, resultFunction, it -> ((Flux)resultFunction.apply((Connection)it)).flatMap(Result::getRowsUpdated).next(), mappingFunction);
        }

        public ExecuteSpecSupport bind(int index, Object value) {
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            byIndex.put(index, new SettableValue(index, value, null));
            return this.createInstance(byIndex, this.byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bindNull(int index, Class<?> type) {
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            byIndex.put(index, new SettableValue(index, null, type));
            return this.createInstance(byIndex, this.byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bind(String name, Object value) {
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(name, new SettableValue(name, value, null));
            return this.createInstance(this.byIndex, byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bindNull(String name, Class<?> type) {
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(name, new SettableValue(name, null, type));
            return this.createInstance(this.byIndex, byName, this.sqlSupplier);
        }

        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return new ExecuteSpecSupport(byIndex, byName, sqlSupplier);
        }

        public ExecuteSpecSupport bind(Object bean) {
            Assert.notNull((Object)bean, (String)"Bean must not be null!");
            throw new UnsupportedOperationException("Implement me!");
        }

        public ExecuteSpecSupport(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            this.byIndex = byIndex;
            this.byName = byName;
            this.sqlSupplier = sqlSupplier;
        }
    }

    private class DefaultSqlSpec
    implements DatabaseClient.SqlSpec {
        private DefaultSqlSpec() {
        }

        @Override
        public DatabaseClient.GenericExecuteSpec sql(String sql) {
            Assert.hasText((String)sql, (String)"SQL must not be null or empty!");
            return this.sql(() -> sql);
        }

        @Override
        public DatabaseClient.GenericExecuteSpec sql(Supplier<String> sqlSupplier) {
            Assert.notNull(sqlSupplier, (String)"SQL Supplier must not be null!");
            return DefaultDatabaseClient.this.createGenericExecuteSpec(sqlSupplier);
        }
    }
}

