/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.function.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.function.FetchSpec;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.RowsFetchSpec;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import reactor.core.publisher.Mono;

public interface DatabaseClient {
    public SqlSpec execute();

    public SelectFromSpec select();

    public InsertIntoSpec insert();

    public Builder mutate();

    public static DatabaseClient create(ConnectionFactory factory) {
        return new DefaultDatabaseClientBuilder().connectionFactory(factory).build();
    }

    public static Builder builder() {
        return new DefaultDatabaseClientBuilder();
    }

    public static interface BindSpec<S extends BindSpec<S>> {
        public S bind(int var1, Object var2);

        public S bindNull(int var1, Class<?> var2);

        public S bind(String var1, Object var2);

        public S bindNull(String var1, Class<?> var2);

        public S bind(Object var1);
    }

    public static interface InsertSpec<T> {
        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface TypedInsertSpec<T> {
        public InsertSpec<Map<String, Object>> using(T var1);

        public TypedInsertSpec<T> table(String var1);

        public InsertSpec<Map<String, Object>> using(Publisher<T> var1);
    }

    public static interface GenericInsertSpec<T>
    extends InsertSpec<T> {
        public GenericInsertSpec<T> value(String var1, Object var2);

        public GenericInsertSpec<T> nullValue(String var1, Class<?> var2);
    }

    public static interface SelectSpec<S extends SelectSpec<S>> {
        public S project(String ... var1);

        public S orderBy(Sort var1);

        public S page(Pageable var1);
    }

    public static interface TypedSelectSpec<T>
    extends SelectSpec<TypedSelectSpec<T>> {
        public <R> RowsFetchSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();
    }

    public static interface GenericSelectSpec
    extends SelectSpec<GenericSelectSpec> {
        public <R> TypedSelectSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();
    }

    public static interface InsertIntoSpec {
        public GenericInsertSpec<Map<String, Object>> into(String var1);

        public <T> TypedInsertSpec<T> into(Class<T> var1);
    }

    public static interface SelectFromSpec {
        public GenericSelectSpec from(String var1);

        public <T> TypedSelectSpec<T> from(Class<T> var1);
    }

    public static interface TypedExecuteSpec<T>
    extends BindSpec<TypedExecuteSpec<T>> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface GenericExecuteSpec
    extends BindSpec<GenericExecuteSpec> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();

        public Mono<Void> then();
    }

    public static interface SqlSpec {
        public GenericExecuteSpec sql(String var1);

        public GenericExecuteSpec sql(Supplier<String> var1);
    }

    public static interface Builder {
        public Builder connectionFactory(ConnectionFactory var1);

        public Builder exceptionTranslator(R2dbcExceptionTranslator var1);

        public Builder dataAccessStrategy(ReactiveDataAccessStrategy var1);

        public Builder apply(Consumer<Builder> var1);

        public DatabaseClient build();
    }
}

