/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.dialect.LimitClause;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PostgresDialect
implements Dialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(UUID.class, URL.class, URI.class, InetAddress.class));
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final BindMarkersFactory INDEXED = BindMarkersFactory.indexed("$", 1);
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getClause(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        @Override
        public String getClause(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.END;
        }
    };
    private final PostgresArrayColumns ARRAY_COLUMNS = new PostgresArrayColumns(this.getSimpleTypeHolder());

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return INDEXED;
    }

    @Override
    public String generatedKeysClause() {
        return "RETURNING *";
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return this.ARRAY_COLUMNS;
    }

    static class PostgresArrayColumns
    implements ArrayColumns {
        private final SimpleTypeHolder simpleTypes;

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public Class<?> getArrayType(Class<?> userType) {
            Assert.notNull(userType, (String)"Array component type must not be null");
            if (!this.simpleTypes.isSimpleType(userType)) {
                throw new IllegalArgumentException("Unsupported array type: " + ClassUtils.getQualifiedName(userType));
            }
            return ClassUtils.resolvePrimitiveIfNecessary(userType);
        }

        public PostgresArrayColumns(SimpleTypeHolder simpleTypes) {
            this.simpleTypes = simpleTypes;
        }
    }
}

