/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import io.r2dbc.spi.Statement;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindMarkers;

class IndexedBindMarkers
implements BindMarkers {
    private static final AtomicIntegerFieldUpdater<IndexedBindMarkers> COUNTER_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(IndexedBindMarkers.class, "counter");
    private volatile int counter = 0;
    private final int offset;
    private final String prefix;

    IndexedBindMarkers(String prefix, int beginWith) {
        this.prefix = prefix;
        this.offset = beginWith;
    }

    @Override
    public BindMarker next() {
        int index = COUNTER_INCREMENTER.getAndIncrement(this);
        return new IndexedBindMarker(this.prefix + "" + (index + this.offset), index);
    }

    static class IndexedBindMarker
    implements BindMarker {
        private final String placeholder;
        private int index;

        IndexedBindMarker(String placeholder, int index) {
            this.placeholder = placeholder;
            this.index = index;
        }

        @Override
        public String getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public void bind(Statement<?> statement, Object value) {
            statement.bind(this.index, value);
        }

        @Override
        public void bindNull(Statement<?> statement, Class<?> valueType) {
            statement.bindNull(this.index, valueType);
        }
    }
}

