/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;
import org.springframework.data.neo4j.transaction.SessionHolder;
import org.springframework.data.neo4j.web.support.AsyncRequestInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.AsyncWebRequestInterceptor;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;

public class OpenSessionInViewInterceptor
implements BeanFactoryAware,
AsyncWebRequestInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory emf) {
        this.sessionFactory = emf;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getSessionFactory() == null) {
            this.setSessionFactory((SessionFactory)beanFactory.getBean(SessionFactory.class));
        }
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((WebRequest)request);
        if (asyncManager.hasConcurrentResult() && this.applyCallableInterceptor(asyncManager, participateAttributeName)) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else {
            this.logger.debug((Object)"Opening Neo4j OGM Session in OpenSessionInViewInterceptor");
            Session session = this.sessionFactory.openSession();
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)sessionHolder));
            AsyncRequestInterceptor interceptor = new AsyncRequestInterceptor(this.getSessionFactory(), sessionHolder);
            asyncManager.registerCallableInterceptor((Object)participateAttributeName, (CallableProcessingInterceptor)interceptor);
            asyncManager.registerDeferredResultInterceptor((Object)participateAttributeName, (DeferredResultProcessingInterceptor)interceptor);
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        if (!this.decrementParticipateCount(request)) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
            this.logger.debug((Object)"Closed Neo4j OGM Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession();
        }
    }

    private boolean decrementParticipateCount(WebRequest request) {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
        } else {
            request.removeAttribute(participateAttributeName, 0);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(WebRequest request) {
        if (!this.decrementParticipateCount(request)) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }

    private boolean applyCallableInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

