/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;

public class SharedSessionCreator {
    public static Session createSharedSession(SessionFactory sessionFactory) {
        return (Session)Proxy.newProxyInstance(SharedSessionCreator.class.getClassLoader(), new Class[]{Session.class}, (InvocationHandler)new SharedSessionInvocationHandler(sessionFactory));
    }

    private static class SharedSessionInvocationHandler
    implements InvocationHandler {
        private final SessionFactory targetFactory;

        public SharedSessionInvocationHandler(SessionFactory target) {
            this.targetFactory = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return "Spring Session proxy for target factory [" + this.targetFactory + "]";
            }
            if (method.getName().equals("beginTransaction")) {
                throw new IllegalStateException("Not allowed to create transaction on shared Session - use Spring transactions instead");
            }
            Session target = SessionFactoryUtils.getSession(this.targetFactory);
            if (target == null) {
                target = this.targetFactory.openSession();
            }
            try {
                Object object = method.invoke((Object)target, args);
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                SessionFactoryUtils.closeSession();
            }
        }
    }
}

