/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.exception.InvalidDepthException;
import org.neo4j.ogm.exception.NotFoundException;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.transaction.SessionHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog(SessionFactoryUtils.class);
    private static ThreadLocal<Session> sessions = new ThreadLocal();

    public static void closeSession() {
        sessions.remove();
    }

    public static Session getSession(SessionFactory sessionFactory) throws IllegalStateException {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null) {
            if (!sessionHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                sessionHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, sessionFactory, false));
            }
            return sessionHolder.getSession();
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("No Neo4j Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        Session session = sessions.get();
        logger.debug((Object)("Found existing Neo4j Session [" + session + "]"));
        if (session == null) {
            session = sessionFactory.openSession();
            logger.debug((Object)("Opening Neo4j Session [" + session + "]"));
            sessions.set(session);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for Neo4j Session");
            sessionHolder = new SessionHolder(session);
            sessionHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, sessionFactory, true));
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
        }
        return session;
    }

    public static DataAccessException convertOgmAccessException(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NotFoundException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof InvalidDepthException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ResultProcessingException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static class SessionSynchronization
    extends ResourceHolderSynchronization<SessionHolder, SessionFactory>
    implements Ordered {
        private final boolean newSession;

        SessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, boolean newSession) {
            super((ResourceHolder)sessionHolder, (Object)sessionFactory);
            this.newSession = newSession;
        }

        public int getOrder() {
            return 900;
        }

        public void flushResource(SessionHolder resourceHolder) {
        }

        protected boolean shouldUnbindAtCompletion() {
            return this.newSession;
        }

        protected boolean shouldReleaseAfterCompletion(SessionHolder resourceHolder) {
            return false;
        }
    }
}

