/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryCreator;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedGraphRepositoryQuery
implements RepositoryQuery {
    private DerivedQueryDefinition queryDefinition;
    private final GraphQueryMethod graphQueryMethod;
    protected final Session session;
    private final int DEFAULT_QUERY_DEPTH = 1;

    public DerivedGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
        EntityMetadata info = graphQueryMethod.getEntityInformation();
        PartTree tree = new PartTree(graphQueryMethod.getName(), info.getJavaType());
        this.queryDefinition = (DerivedQueryDefinition)new DerivedQueryCreator(tree, info.getJavaType()).createQuery();
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.graphQueryMethod.getParameters(), parameters);
        Pageable pageable = accessor.getPageable();
        Sort sort = accessor.getSort();
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        Class<?> concreteType = this.graphQueryMethod.resolveConcreteReturnType();
        int queryDepth = this.calculateQueryDepth(parameters);
        Filters params = this.resolveParams(parameters);
        if (returnType.equals(Void.class)) {
            throw new RuntimeException("Derived Queries must have a return type");
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            PagingAndSorting pagingAndSorting = this.configurePagingAndSorting(pageable, sort);
            List resultList = this.queryResults(concreteType, queryDepth, params, pagingAndSorting);
            if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
                return this.createPage(this.graphQueryMethod, resultList, pageable);
            }
            return resultList;
        }
        Iterator objectIterator = this.session.loadAll(returnType, params, queryDepth).iterator();
        if (objectIterator.hasNext()) {
            return objectIterator.next();
        }
        return null;
    }

    public QueryMethod getQueryMethod() {
        return this.graphQueryMethod;
    }

    private List queryResults(Class<?> concreteType, int queryDepth, Filters params, PagingAndSorting pagingAndSorting) {
        List resultList;
        switch (pagingAndSorting.configuration()) {
            case 0: {
                resultList = (List)this.session.loadAll(concreteType, params, pagingAndSorting.sortOrder, pagingAndSorting.pagination, queryDepth);
                break;
            }
            case 1: {
                resultList = (List)this.session.loadAll(concreteType, params, pagingAndSorting.pagination, queryDepth);
                break;
            }
            case 2: {
                resultList = (List)this.session.loadAll(concreteType, params, pagingAndSorting.sortOrder, queryDepth);
                break;
            }
            case 3: {
                resultList = (List)this.session.loadAll(concreteType, params, queryDepth);
                break;
            }
            default: {
                resultList = (List)this.session.loadAll(concreteType, params, queryDepth);
            }
        }
        return resultList;
    }

    private int calculateQueryDepth(Object[] parameters) {
        int queryDepth = 1;
        if (this.graphQueryMethod.hasStaticDepth()) {
            queryDepth = this.graphQueryMethod.getQueryDepth();
        } else if (this.graphQueryMethod.getQueryDepthParamIndex() != null) {
            queryDepth = (Integer)parameters[this.graphQueryMethod.getQueryDepthParamIndex()];
        }
        return queryDepth;
    }

    private Filters resolveParams(Object[] parameters) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (this.graphQueryMethod.getQueryDepthParamIndex() != null && (this.graphQueryMethod.getQueryDepthParamIndex() == null || this.graphQueryMethod.getQueryDepthParamIndex() == i)) continue;
            params.put(i, parameters[i]);
        }
        List<CypherFilter> cypherFilters = this.queryDefinition.getCypherFilters();
        Filters queryParams = new Filters();
        for (CypherFilter cypherFilter : cypherFilters) {
            Filter filter = cypherFilter.toFilter();
            filter.setPropertyValue(params.get(cypherFilter.getPropertyPosition()));
            queryParams.add(new Filter[]{filter});
        }
        return queryParams;
    }

    protected Object createPage(GraphQueryMethod graphQueryMethod, List resultList, Pageable pageable) {
        if (pageable == null) {
            return graphQueryMethod.isPageQuery() ? new PageImpl(resultList) : new SliceImpl(resultList);
        }
        int currentTotal = pageable.getOffset() + resultList.size() + (resultList.size() == pageable.getPageSize() ? pageable.getPageSize() : 0);
        int resultWindowSize = Math.min(resultList.size(), pageable.getPageSize());
        boolean hasNext = resultWindowSize < resultList.size();
        List resultListPage = resultList.subList(0, resultWindowSize);
        return graphQueryMethod.isPageQuery() ? new PageImpl(resultListPage, pageable, (long)currentTotal) : new SliceImpl(resultListPage, pageable, hasNext);
    }

    private SortOrder convert(Sort sort) {
        SortOrder sortOrder = new SortOrder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }

    private PagingAndSorting configurePagingAndSorting(Pageable pageable, Sort sort) {
        SortOrder sortOrder = null;
        Pagination pagination = null;
        if (pageable != null) {
            pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize());
            if (pageable.getSort() != null) {
                sortOrder = this.convert(pageable.getSort());
            }
        }
        if (sort != null) {
            sortOrder = this.convert(sort);
        }
        if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
            if (this.graphQueryMethod.isSliceQuery()) {
                pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize() + 1);
                pagination.setOffset(Integer.valueOf(pageable.getPageNumber() * pageable.getPageSize()));
            } else {
                pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize());
            }
        }
        PagingAndSorting pagingAndSorting = new PagingAndSorting(pagination, sortOrder);
        return pagingAndSorting;
    }

    class PagingAndSorting {
        static final int PAGING_AND_SORTING = 0;
        static final int PAGING_ONLY = 1;
        static final int SORTING_ONLY = 2;
        static final int NO_PAGING_OR_SORTING = 3;
        Pagination pagination;
        SortOrder sortOrder;

        public PagingAndSorting(Pagination pagination, SortOrder sortOrder) {
            this.pagination = pagination;
            this.sortOrder = sortOrder;
        }

        int configuration() {
            if (this.pagination != null && this.sortOrder != null) {
                return 0;
            }
            if (this.pagination != null && this.sortOrder == null) {
                return 1;
            }
            if (this.pagination == null && this.sortOrder != null) {
                return 2;
            }
            return 3;
        }
    }
}

