/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.StringUtils;

public class GraphRepositoryQuery
implements RepositoryQuery {
    private final GraphQueryMethod graphQueryMethod;
    protected final Session session;
    private static final String SKIP = "sdnSkip";
    private static final String LIMIT = "sdnLimit";
    private static final String SKIP_LIMIT = " SKIP {sdnSkip} LIMIT {sdnLimit}";
    private static final String ORDER_BY_CLAUSE = " ORDER BY %s";

    public GraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
    }

    public final Object execute(Object[] parameters) {
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        Class<?> concreteType = this.graphQueryMethod.resolveConcreteReturnType();
        Map<String, Object> params = this.resolveParams(parameters);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.graphQueryMethod.getParameters(), parameters);
        ResultProcessor processor = this.graphQueryMethod.getResultProcessor();
        Object result = this.execute(returnType, concreteType, this.getQueryString(), params, (ParameterAccessor)accessor);
        return Result.class.equals(returnType) ? result : processor.withDynamicProjection((ParameterAccessor)accessor).processResult(result);
    }

    protected Object execute(Class<?> returnType, Class<?> concreteType, String cypherQuery, Map<String, Object> queryParams, ParameterAccessor parameterAccessor) {
        Pageable pageable = parameterAccessor.getPageable();
        Sort sort = parameterAccessor.getSort();
        if (pageable != null && pageable.getSort() != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            cypherQuery = this.addSorting(cypherQuery, sort);
        }
        if (returnType.equals(Void.class) || returnType.equals(Void.TYPE)) {
            this.session.query(cypherQuery, queryParams);
            return null;
        }
        if (Iterable.class.isAssignableFrom(returnType) && !this.queryReturnsStatistics()) {
            if (Map.class.isAssignableFrom(concreteType)) {
                return this.session.query(cypherQuery, queryParams).queryResults();
            }
            if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
                cypherQuery = cypherQuery + SKIP_LIMIT;
                queryParams.put(SKIP, pageable.getPageNumber() * pageable.getPageSize());
                if (this.graphQueryMethod.isSliceQuery()) {
                    queryParams.put(LIMIT, pageable.getPageSize() + 1);
                } else {
                    queryParams.put(LIMIT, pageable.getPageSize());
                }
                List resultList = (List)this.session.query(concreteType, cypherQuery, queryParams);
                return this.createPage(this.graphQueryMethod, resultList, pageable, this.computeCount(queryParams));
            }
            List resultList = (List)this.session.query(concreteType, cypherQuery, queryParams);
            return resultList;
        }
        if (this.queryReturnsStatistics()) {
            return this.session.query(cypherQuery, queryParams);
        }
        return this.session.queryForObject(returnType, cypherQuery, queryParams);
    }

    private Map<String, Object> resolveParams(Object[] parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameters methodParameters = this.graphQueryMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = methodParameters.getParameter(i);
            Object parameterValue = this.session.resolveGraphIdFor(parameters[i]);
            if (parameterValue == null) {
                parameterValue = parameters[i];
            }
            if (parameter.isNamedParameter()) {
                params.put(parameter.getName(), parameterValue);
                continue;
            }
            params.put("" + i, parameterValue);
        }
        return params;
    }

    public GraphQueryMethod getQueryMethod() {
        return this.graphQueryMethod;
    }

    protected String getQueryString() {
        return this.getQueryMethod().getQuery();
    }

    private boolean queryReturnsStatistics() {
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        return QueryStatistics.class.isAssignableFrom(returnType) || Result.class.isAssignableFrom(returnType);
    }

    protected Object createPage(GraphQueryMethod graphQueryMethod, List resultList, Pageable pageable, Long count) {
        int currentTotal;
        if (pageable == null) {
            return graphQueryMethod.isPageQuery() ? new PageImpl(resultList) : new SliceImpl(resultList);
        }
        if (count != null) {
            currentTotal = count.intValue();
        } else {
            int pageOffset = pageable.getOffset();
            currentTotal = pageOffset + resultList.size() + (resultList.size() == pageable.getPageSize() ? pageable.getPageSize() : 0);
        }
        int resultWindowSize = Math.min(resultList.size(), pageable.getPageSize());
        boolean hasNext = resultWindowSize < resultList.size();
        List resultListPage = resultList.subList(0, resultWindowSize);
        return graphQueryMethod.isPageQuery() ? new PageImpl(resultListPage, pageable, (long)currentTotal) : new SliceImpl(resultListPage, pageable, hasNext);
    }

    private Long computeCount(Map<String, Object> params) {
        String countQuery = this.graphQueryMethod.getCountQueryString();
        if (countQuery == null || !StringUtils.hasText((String)countQuery)) {
            return null;
        }
        Result countResult = this.session.query(countQuery, params);
        if (countResult != null && countResult.iterator().hasNext()) {
            return ((Number)((Map)countResult.iterator().next()).values().iterator().next()).longValue();
        }
        return null;
    }

    private String addSorting(String baseQuery, Sort sort) {
        if (sort == null) {
            return baseQuery;
        }
        String sortOrder = this.getSortOrder(sort);
        if (sortOrder.isEmpty()) {
            return baseQuery;
        }
        return baseQuery + String.format(ORDER_BY_CLAUSE, sortOrder);
    }

    private String getSortOrder(Sort sort) {
        String result = "";
        for (Sort.Order order : sort) {
            if (!result.isEmpty()) {
                result = result + ", ";
            }
            result = result + order.getProperty() + " " + order.getDirection();
        }
        return result;
    }
}

