/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.QueryResultGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.derived.DerivedGraphRepositoryQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class GraphQueryMethod
extends QueryMethod {
    private final Session session;
    private final Method method;
    private final Query queryAnnotation;
    private final Integer queryDepthParamIndex;
    private final Integer queryDepth;
    private boolean staticDepth;

    public GraphQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, Session session) {
        super(method, metadata, factory);
        this.method = method;
        this.session = session;
        this.queryAnnotation = method.getAnnotation(Query.class);
        this.queryDepthParamIndex = this.getQueryDepthParamIndex(method);
        this.queryDepth = this.getStaticQueryDepth(method);
        if (this.queryDepth != null && this.queryDepthParamIndex != null) {
            throw new IllegalArgumentException(method.getName() + " cannot have both a method @Depth and a parameter @Depth");
        }
    }

    public String getQuery() {
        return this.queryAnnotation.value();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getNamedQueryName() {
        throw new UnsupportedOperationException("OGM does not currently support named queries.");
    }

    public Class<?> resolveConcreteReturnType() {
        Class<?> type = this.method.getReturnType();
        Type genericType = this.method.getGenericReturnType();
        if (Iterable.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType returnType = (ParameterizedType)genericType;
                Type componentType = returnType.getActualTypeArguments()[0];
                if (componentType instanceof TypeVariable) {
                    return this.getDomainClass();
                }
                return componentType instanceof ParameterizedType ? (Class)((ParameterizedType)componentType).getRawType() : (Class)componentType;
            }
            return Object.class;
        }
        return type;
    }

    public RepositoryQuery createQuery() {
        if (this.method.getAnnotation(Query.class) != null) {
            if (this.resolveConcreteReturnType().isAnnotationPresent(QueryResult.class)) {
                return new QueryResultGraphRepositoryQuery(this, this.session);
            }
            return new GraphRepositoryQuery(this, this.session);
        }
        return new DerivedGraphRepositoryQuery(this, this.session);
    }

    public Integer getQueryDepthParamIndex() {
        return this.queryDepthParamIndex;
    }

    public Integer getQueryDepth() {
        return this.queryDepth;
    }

    public boolean hasStaticDepth() {
        return this.staticDepth;
    }

    private Integer getQueryDepthParamIndex(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].length <= 0) continue;
            for (Annotation annotation : annotations[i]) {
                if (annotation.annotationType() != Depth.class) continue;
                if (method.getParameterTypes()[i] == Integer.class || method.getParameterTypes()[i] == Integer.TYPE) {
                    return i;
                }
                throw new IllegalArgumentException("Depth parameter in " + method.getName() + " must be an integer");
            }
        }
        return null;
    }

    private Integer getStaticQueryDepth(Method method) {
        if (method.isAnnotationPresent(Depth.class)) {
            this.staticDepth = true;
            return method.getAnnotation(Depth.class).value();
        }
        return null;
    }

    public String getCountQueryString() {
        return this.queryAnnotation != null ? this.queryAnnotation.countQuery() : null;
    }
}

