/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.stereotype.Repository;

@Repository
@Deprecated
public class GraphRepositoryImpl<T>
implements GraphRepository<T> {
    private static final int DEFAULT_QUERY_DEPTH = 1;
    private final Class<T> clazz;
    private final Neo4jOperations neo4jOperations;

    public GraphRepositoryImpl(Class<T> clazz, Neo4jOperations neo4jOperations) {
        this.clazz = clazz;
        this.neo4jOperations = neo4jOperations;
    }

    public <S extends T> S save(S entity) {
        this.neo4jOperations.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        for (S entity : entities) {
            this.neo4jOperations.save(entity);
        }
        return entities;
    }

    public T findOne(Long id) {
        return this.neo4jOperations.load(this.clazz, id);
    }

    public boolean exists(Long id) {
        return this.findOne(id) != null;
    }

    public long count() {
        return this.neo4jOperations.count(this.clazz);
    }

    public void delete(Long id) {
        T o = this.findOne(id);
        if (o != null) {
            this.neo4jOperations.delete(o);
        }
    }

    public void delete(T t) {
        this.neo4jOperations.delete(t);
    }

    public void delete(Iterable<? extends T> ts) {
        for (T t : ts) {
            this.neo4jOperations.delete(t);
        }
    }

    public void deleteAll() {
        this.neo4jOperations.deleteAll(this.clazz);
    }

    @Override
    public <S extends T> S save(S s, int depth) {
        this.neo4jOperations.save(s, depth);
        return s;
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> ses, int depth) {
        this.neo4jOperations.save(ses, depth);
        return ses;
    }

    @Override
    public T findOne(Long id, int depth) {
        return this.neo4jOperations.load(this.clazz, id, depth);
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAll(1);
    }

    @Override
    public Iterable<T> findAll(int depth) {
        return this.neo4jOperations.loadAll(this.clazz, depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> longs) {
        return this.findAll(longs, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, int depth) {
        return this.neo4jOperations.loadAll(this.clazz, (Collection)ids, depth);
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.findAll(sort, 1);
    }

    @Override
    public Iterable<T> findAll(Sort sort, int depth) {
        return this.neo4jOperations.loadAll(this.clazz, this.convert(sort), depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, Sort sort) {
        return this.findAll(ids, sort, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, Sort sort, int depth) {
        return this.neo4jOperations.loadAll(this.clazz, (Collection)ids, this.convert(sort), depth);
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.findAll(pageable, 1);
    }

    @Override
    public Page<T> findAll(Pageable pageable, int depth) {
        Collection<T> data = this.neo4jOperations.loadAll(this.clazz, this.convert(pageable.getSort()), new Pagination(pageable.getPageNumber(), pageable.getPageSize()), depth);
        return this.updatePage(pageable, new ArrayList<T>(data));
    }

    private SortOrder convert(Sort sort) {
        SortOrder sortOrder = new SortOrder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }

    private Page<T> updatePage(Pageable pageable, List<T> results) {
        int pageSize = pageable.getPageSize();
        int pageOffset = pageable.getOffset();
        int total = pageOffset + results.size() + (results.size() == pageSize ? pageSize : 0);
        return new PageImpl(results, pageable, (long)total);
    }
}

