/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import javax.annotation.Resource;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.dao.support.PersistenceExceptionTranslationInterceptor;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.template.Neo4jOgmExceptionTranslator;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.template.Neo4jTemplate;
import org.springframework.data.neo4j.transaction.GraphTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@Configuration
@Deprecated
public abstract class Neo4jConfiguration {
    private final Logger logger = LoggerFactory.getLogger(Neo4jConfiguration.class);
    @Resource
    private Environment environment;

    @Bean
    public Session getSession() throws Exception {
        this.logger.info("Initialising Neo4jSession");
        SessionFactory sessionFactory = this.getSessionFactory();
        Assert.notNull((Object)sessionFactory, (String)"You must provide a SessionFactory instance in your Spring configuration classes");
        return sessionFactory.openSession();
    }

    @Bean
    public Neo4jOperations neo4jTemplate() throws Exception {
        return new Neo4jTemplate(this.getSession());
    }

    @Bean
    public Neo4jMappingContext neo4jMappingContext() throws Exception {
        return new Neo4jMappingContext(this.getSessionFactory().metaData());
    }

    @Bean
    public PersistenceExceptionTranslator persistenceExceptionTranslator() {
        this.logger.info("Initialising PersistenceExceptionTranslator");
        return new PersistenceExceptionTranslator(){

            public DataAccessException translateExceptionIfPossible(RuntimeException e) {
                Neo4jConfiguration.this.logger.info("Intercepted exception");
                throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
            }
        };
    }

    @Bean
    public PersistenceExceptionTranslationInterceptor translationInterceptor() {
        this.logger.info("Initialising PersistenceExceptionTranslationInterceptor");
        return new PersistenceExceptionTranslationInterceptor(this.persistenceExceptionTranslator());
    }

    @Bean
    public PlatformTransactionManager transactionManager() throws Exception {
        this.logger.info("Initialising GraphTransactionManager");
        Session session = this.getSession();
        Assert.notNull((Object)session, (String)"You must provide a Session instance in your Spring configuration classes");
        return new GraphTransactionManager(session);
    }

    @Bean
    PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        this.logger.info("Initialising PersistenceExceptionTranslationPostProcessor");
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    public abstract SessionFactory getSessionFactory();
}

