/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.ChangeStreamOptions;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.messaging.MessageListener;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ChangeStreamRequest<T>
implements SubscriptionRequest<ChangeStreamDocument<Document>, T, ChangeStreamRequestOptions> {
    private final MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener;
    private final ChangeStreamRequestOptions options;

    public ChangeStreamRequest(MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener, SubscriptionRequest.RequestOptions options) {
        Assert.notNull(messageListener, (String)"MessageListener must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        this.options = options instanceof ChangeStreamRequestOptions ? (ChangeStreamRequestOptions)options : ChangeStreamRequestOptions.of(options);
        this.messageListener = messageListener;
    }

    @Override
    public MessageListener<ChangeStreamDocument<Document>, ? super T> getMessageListener() {
        return this.messageListener;
    }

    @Override
    public ChangeStreamRequestOptions getRequestOptions() {
        return this.options;
    }

    public static ChangeStreamRequestBuilder builder() {
        return new ChangeStreamRequestBuilder();
    }

    public static <T> ChangeStreamRequestBuilder<T> builder(MessageListener<ChangeStreamDocument<Document>, ? super T> listener) {
        ChangeStreamRequestBuilder<? super T> builder = new ChangeStreamRequestBuilder<T>();
        return builder.publishTo(listener);
    }

    public static class ChangeStreamRequestBuilder<T> {
        @Nullable
        private String collectionName;
        @Nullable
        private MessageListener<ChangeStreamDocument<Document>, ? super T> listener;
        private ChangeStreamOptions.ChangeStreamOptionsBuilder delegate = ChangeStreamOptions.builder();

        private ChangeStreamRequestBuilder() {
        }

        public ChangeStreamRequestBuilder<T> collection(String collectionName) {
            Assert.hasText((String)collectionName, (String)"CollectionName must not be null!");
            this.collectionName = collectionName;
            return this;
        }

        public ChangeStreamRequestBuilder<T> publishTo(MessageListener<ChangeStreamDocument<Document>, ? super T> messageListener) {
            Assert.notNull(messageListener, (String)"MessageListener must not be null!");
            this.listener = messageListener;
            return this;
        }

        public ChangeStreamRequestBuilder<T> filter(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, (String)"Aggregation must not be null!");
            this.delegate.filter(aggregation);
            return this;
        }

        public ChangeStreamRequestBuilder<T> filter(Document ... pipeline) {
            Assert.notNull((Object)pipeline, (String)"Aggregation pipeline must not be null!");
            Assert.noNullElements((Object[])pipeline, (String)"Aggregation pipeline must not contain null elements!");
            this.delegate.filter(pipeline);
            return this;
        }

        public ChangeStreamRequestBuilder collation(Collation collation) {
            Assert.notNull((Object)collation, (String)"Collation must not be null!");
            this.delegate.collation(collation);
            return this;
        }

        public ChangeStreamRequestBuilder<T> resumeToken(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, (String)"Resume token not be null!");
            this.delegate.resumeToken(resumeToken);
            return this;
        }

        public ChangeStreamRequestBuilder<T> fullDocumentLookup(FullDocument lookup) {
            Assert.notNull((Object)lookup, (String)"FullDocument not be null!");
            this.delegate.fullDocumentLookup(lookup);
            return this;
        }

        public ChangeStreamRequest<T> build() {
            Assert.notNull(this.listener, (String)"MessageListener must not be null!");
            Assert.hasText((String)this.collectionName, (String)"CollectionName must not be null!");
            return new ChangeStreamRequest<T>(this.listener, new ChangeStreamRequestOptions(this.collectionName, this.delegate.build()));
        }
    }

    public static class ChangeStreamRequestOptions
    implements SubscriptionRequest.RequestOptions {
        private final String collectionName;
        private final ChangeStreamOptions options;

        public ChangeStreamRequestOptions(String collectionName, ChangeStreamOptions options) {
            Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
            Assert.notNull((Object)options, (String)"Options must not be null!");
            this.collectionName = collectionName;
            this.options = options;
        }

        public static ChangeStreamRequestOptions of(SubscriptionRequest.RequestOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ChangeStreamRequestOptions(options.getCollectionName(), ChangeStreamOptions.builder().build());
        }

        public ChangeStreamOptions getChangeStreamOptions() {
            return this.options;
        }

        @Override
        public String getCollectionName() {
            return this.collectionName;
        }
    }
}

