/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.Document;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ChangeStreamEvent<T> {
    @Nullable
    private final ChangeStreamDocument<Document> raw;
    private final Class<T> targetType;
    private final MongoConverter converter;
    private final AtomicReference<T> converted = new AtomicReference();

    public ChangeStreamEvent(@Nullable ChangeStreamDocument<Document> raw, Class<T> targetType, MongoConverter converter) {
        this.raw = raw;
        this.targetType = targetType;
        this.converter = converter;
    }

    @Nullable
    public ChangeStreamDocument<Document> getRaw() {
        return this.raw;
    }

    @Nullable
    public T getBody() {
        if (this.raw == null) {
            return null;
        }
        if (this.raw.getFullDocument() == null) {
            return this.targetType.cast(this.raw.getFullDocument());
        }
        return this.getConverted();
    }

    private T getConverted() {
        Object result = this.converted.get();
        if (result != null) {
            return result;
        }
        if (ClassUtils.isAssignable(Document.class, ((Document)this.raw.getFullDocument()).getClass())) {
            result = this.converter.read(this.targetType, this.raw.getFullDocument());
            return this.converted.compareAndSet(null, result) ? result : this.converted.get();
        }
        if (this.converter.getConversionService().canConvert(((Document)this.raw.getFullDocument()).getClass(), this.targetType)) {
            result = this.converter.getConversionService().convert(this.raw.getFullDocument(), this.targetType);
            return (T)(this.converted.compareAndSet(null, result) ? result : this.converted.get());
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting %s to %s", ((Document)this.raw.getFullDocument()).getClass(), this.targetType));
    }

    public String toString() {
        return "ChangeStreamEvent {raw=" + this.raw + ", targetType=" + this.targetType + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeStreamEvent)) {
            return false;
        }
        ChangeStreamEvent other = (ChangeStreamEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChangeStreamDocument<Document> this$raw = this.getRaw();
        ChangeStreamDocument<Document> other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        Class<T> this$targetType = this.targetType;
        Class<T> other$targetType = other.targetType;
        if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
            return false;
        }
        MongoConverter this$converter = this.converter;
        MongoConverter other$converter = other.converter;
        if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
            return false;
        }
        T this$converted = this.getConverted();
        T other$converted = other.getConverted();
        return !(this$converted == null ? other$converted != null : !this$converted.equals(other$converted));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeStreamEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChangeStreamDocument<Document> $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        Class<T> $targetType = this.targetType;
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        MongoConverter $converter = this.converter;
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        T $converted = this.getConverted();
        result = result * 59 + ($converted == null ? 43 : $converted.hashCode());
        return result;
    }
}

