/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.mongodb.MongodbSerializer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

class SpringDataMongodbSerializer
extends MongodbSerializer {
    private static final String ID_KEY = "_id";
    private static final Set<PathType> PATH_TYPES;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public SpringDataMongodbSerializer(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.mappingContext = converter.getMappingContext();
        this.converter = converter;
        this.mapper = new QueryMapper(converter);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        if (!metadata.getPathType().equals((Object)PathType.PROPERTY)) {
            return super.getKeyForPath(expr, metadata);
        }
        Path parent = metadata.getParent();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(metadata.getName());
        return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
    }

    protected DBObject asDBObject(String key, Object value) {
        if (ID_KEY.equals(key)) {
            return this.mapper.getMappedObject(super.asDBObject(key, value), null);
        }
        return super.asDBObject(key, value instanceof Pattern ? value : this.converter.convertToMongoType(value));
    }

    protected boolean isReference(Path<?> path) {
        MongoPersistentProperty property = this.getPropertyForPotentialDbRef(path);
        return property == null ? false : property.isAssociation();
    }

    protected DBRef asReference(Object constant) {
        return this.asReference(constant, null);
    }

    protected DBRef asReference(Object constant, Path<?> path) {
        return this.converter.toDBRef(constant, this.getPropertyForPotentialDbRef(path));
    }

    protected String asDBKey(Operation<?> expr, int index) {
        Expression arg = expr.getArg(index);
        String key = super.asDBKey(expr, index);
        if (!(arg instanceof Path)) {
            return key;
        }
        Path path = (Path)arg;
        if (!this.isReference(path)) {
            return key;
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        return property.isIdProperty() ? key.replaceAll("._id$", "") : key;
    }

    protected Object convert(Path<?> path, Constant<?> constant) {
        if (!this.isReference(path)) {
            return super.convert(path, constant);
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        return property.isIdProperty() ? this.asReference(constant.getConstant(), path.getMetadata().getParent()) : this.asReference(constant.getConstant(), path);
    }

    private MongoPersistentProperty getPropertyFor(Path<?> path) {
        Path parent = path.getMetadata().getParent();
        if (parent == null || !PATH_TYPES.contains(path.getMetadata().getPathType())) {
            return null;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        return entity != null ? (MongoPersistentProperty)entity.getPersistentProperty(path.getMetadata().getName()) : null;
    }

    private MongoPersistentProperty getPropertyForPotentialDbRef(Path<?> path) {
        if (path == null) {
            return null;
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        PathMetadata metadata = path.getMetadata();
        if (property != null && property.isIdProperty() && metadata != null && metadata.getParent() != null) {
            return this.getPropertyFor(metadata.getParent());
        }
        return property;
    }

    static {
        HashSet<PathType> pathTypes = new HashSet<PathType>();
        pathTypes.add(PathType.VARIABLE);
        pathTypes.add(PathType.PROPERTY);
        PATH_TYPES = Collections.unmodifiableSet(pathTypes);
    }
}

