/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Update {
    private Set<String> keysToUpdate = new HashSet<String>();
    private Map<String, Object> modifierOps = new LinkedHashMap<String, Object>();
    private Map<String, PushOperatorBuilder> pushCommandBuilders = new LinkedHashMap<String, PushOperatorBuilder>(1);

    public static Update update(String key, Object value) {
        return new Update().set(key, value);
    }

    public static Update fromDBObject(DBObject object, String ... exclude) {
        Update update = new Update();
        List<String> excludeList = Arrays.asList(exclude);
        for (String key : object.keySet()) {
            if (excludeList.contains(key)) continue;
            Object value = object.get(key);
            update.modifierOps.put(key, value);
            if (Update.isKeyword(key) && value instanceof DBObject) {
                update.keysToUpdate.addAll(((DBObject)value).keySet());
                continue;
            }
            update.keysToUpdate.add(key);
        }
        return update;
    }

    public Update set(String key, Object value) {
        this.addMultiFieldOperation("$set", key, value);
        return this;
    }

    public Update setOnInsert(String key, Object value) {
        this.addMultiFieldOperation("$setOnInsert", key, value);
        return this;
    }

    public Update unset(String key) {
        this.addMultiFieldOperation("$unset", key, 1);
        return this;
    }

    public Update inc(String key, Number inc) {
        this.addMultiFieldOperation("$inc", key, inc);
        return this;
    }

    public Update push(String key, Object value) {
        this.addMultiFieldOperation("$push", key, value);
        return this;
    }

    public PushOperatorBuilder push(String key) {
        if (!this.pushCommandBuilders.containsKey(key)) {
            this.pushCommandBuilders.put(key, new PushOperatorBuilder(key));
        }
        return this.pushCommandBuilders.get(key);
    }

    public Update pushAll(String key, Object[] values) {
        this.addMultiFieldOperation("$pushAll", key, Arrays.copyOf(values, values.length));
        return this;
    }

    public AddToSetBuilder addToSet(String key) {
        return new AddToSetBuilder(key);
    }

    public Update addToSet(String key, Object value) {
        this.addMultiFieldOperation("$addToSet", key, value);
        return this;
    }

    public Update pop(String key, Position pos) {
        this.addMultiFieldOperation("$pop", key, pos == Position.FIRST ? -1 : 1);
        return this;
    }

    public Update pull(String key, Object value) {
        this.addMultiFieldOperation("$pull", key, value);
        return this;
    }

    public Update pullAll(String key, Object[] values) {
        this.addMultiFieldOperation("$pullAll", key, Arrays.copyOf(values, values.length));
        return this;
    }

    public Update rename(String oldName, String newName) {
        this.addMultiFieldOperation("$rename", oldName, newName);
        return this;
    }

    public Update currentDate(String key) {
        this.addMultiFieldOperation("$currentDate", key, true);
        return this;
    }

    public Update currentTimestamp(String key) {
        this.addMultiFieldOperation("$currentDate", key, new BasicDBObject("$type", (Object)"timestamp"));
        return this;
    }

    public Update multiply(String key, Number multiplier) {
        Assert.notNull((Object)multiplier, (String)"Multiplier must not be 'null'.");
        this.addMultiFieldOperation("$mul", key, multiplier.doubleValue());
        return this;
    }

    public Update max(String key, Object value) {
        Assert.notNull((Object)value, (String)"Value for max operation must not be 'null'.");
        this.addMultiFieldOperation("$max", key, value);
        return this;
    }

    public Update min(String key, Object value) {
        Assert.notNull((Object)value, (String)"Value for min operation must not be 'null'.");
        this.addMultiFieldOperation("$min", key, value);
        return this;
    }

    public BitwiseOperatorBuilder bitwise(String key) {
        return new BitwiseOperatorBuilder(this, key);
    }

    public DBObject getUpdateObject() {
        return new BasicDBObject(this.modifierOps);
    }

    @Deprecated
    protected void addFieldOperation(String operator, String key, Object value) {
        Assert.hasText((String)key, (String)"Key/Path for update must not be null or blank.");
        this.modifierOps.put(operator, new BasicDBObject(key, value));
        this.keysToUpdate.add(key);
    }

    protected void addMultiFieldOperation(String operator, String key, Object value) {
        BasicDBObject keyValueMap;
        Assert.hasText((String)key, (String)"Key/Path for update must not be null or blank.");
        Object existingValue = this.modifierOps.get(operator);
        if (existingValue == null) {
            keyValueMap = new BasicDBObject();
            this.modifierOps.put(operator, keyValueMap);
        } else if (existingValue instanceof BasicDBObject) {
            keyValueMap = (BasicDBObject)existingValue;
        } else {
            throw new InvalidDataAccessApiUsageException("Modifier Operations should be a LinkedHashMap but was " + existingValue.getClass());
        }
        keyValueMap.put(key, value);
        this.keysToUpdate.add(key);
    }

    public boolean modifies(String key) {
        return this.keysToUpdate.contains(key);
    }

    private static boolean isKeyword(String key) {
        return StringUtils.startsWithIgnoreCase((String)key, (String)"$");
    }

    public int hashCode() {
        return this.getUpdateObject().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Update that = (Update)obj;
        return this.getUpdateObject().equals(that.getUpdateObject());
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.getUpdateObject());
    }

    public static class BitwiseOperatorBuilder {
        private final String key;
        private final Update reference;
        private static final String BIT_OPERATOR = "$bit";

        protected BitwiseOperatorBuilder(Update reference, String key) {
            Assert.notNull((Object)reference, (String)"Reference must not be null!");
            Assert.notNull((Object)key, (String)"Key must not be null!");
            this.reference = reference;
            this.key = key;
        }

        public Update and(long value) {
            this.addFieldOperation(BitwiseOperator.AND, value);
            return this.reference;
        }

        public Update or(long value) {
            this.addFieldOperation(BitwiseOperator.OR, value);
            return this.reference;
        }

        public Update xor(long value) {
            this.addFieldOperation(BitwiseOperator.XOR, value);
            return this.reference;
        }

        private void addFieldOperation(BitwiseOperator operator, Number value) {
            this.reference.addMultiFieldOperation(BIT_OPERATOR, this.key, new BasicDBObject(operator.toString(), (Object)value));
        }

        private static enum BitwiseOperator {
            AND,
            OR,
            XOR;


            public String toString() {
                return super.toString().toLowerCase();
            }
        }
    }

    public class AddToSetBuilder {
        private final String key;

        public AddToSetBuilder(String key) {
            this.key = key;
        }

        public Update each(Object ... values) {
            return Update.this.addToSet(this.key, new Each(values));
        }

        public Update value(Object value) {
            return Update.this.addToSet(this.key, value);
        }
    }

    public class PushOperatorBuilder {
        private final String key;
        private final Modifiers modifiers;

        PushOperatorBuilder(String key) {
            this.key = key;
            this.modifiers = new Modifiers();
        }

        public Update each(Object ... values) {
            this.modifiers.addModifier(new Each(values));
            return Update.this.push(this.key, this.modifiers);
        }

        public PushOperatorBuilder slice(int count) {
            this.modifiers.addModifier(new Slice(count));
            return this;
        }

        public PushOperatorBuilder atPosition(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Position must be greater than or equal to zero.");
            }
            this.modifiers.addModifier(new PositionModifier(position));
            return this;
        }

        public PushOperatorBuilder atPosition(Position position) {
            if (position == null || Position.LAST.equals((Object)position)) {
                return this;
            }
            this.modifiers.addModifier(new PositionModifier(0));
            return this;
        }

        public Update value(Object value) {
            return Update.this.push(this.key, value);
        }

        public int hashCode() {
            int result = 17;
            result += 31 * result + this.getOuterType().hashCode();
            result += 31 * result + ObjectUtils.nullSafeHashCode((Object)this.key);
            result += 31 * result + ObjectUtils.nullSafeHashCode((Object)this.modifiers);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PushOperatorBuilder that = (PushOperatorBuilder)obj;
            if (!this.getOuterType().equals(that.getOuterType())) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key) && ObjectUtils.nullSafeEquals((Object)this.modifiers, (Object)that.modifiers);
        }

        private Update getOuterType() {
            return Update.this;
        }
    }

    private static class Slice
    implements Modifier {
        private int count;

        public Slice(int count) {
            this.count = count;
        }

        @Override
        public String getKey() {
            return "$slice";
        }

        @Override
        public Object getValue() {
            return this.count;
        }
    }

    private static class PositionModifier
    implements Modifier {
        private final int position;

        public PositionModifier(int position) {
            this.position = position;
        }

        @Override
        public String getKey() {
            return "$position";
        }

        @Override
        public Object getValue() {
            return this.position;
        }
    }

    private static class Each
    implements Modifier {
        private Object[] values;

        public Each(Object ... values) {
            this.values = this.extractValues(values);
        }

        private Object[] extractValues(Object[] values) {
            if (values == null || values.length == 0) {
                return values;
            }
            if (values.length == 1 && values[0] instanceof Collection) {
                return ((Collection)values[0]).toArray();
            }
            return Arrays.copyOf(values, values.length);
        }

        @Override
        public String getKey() {
            return "$each";
        }

        @Override
        public Object getValue() {
            return this.values;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object[])this.values);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.values, (Object)((Each)that).values);
        }
    }

    public static interface Modifier {
        public String getKey();

        public Object getValue();
    }

    public static class Modifiers {
        private Map<String, Modifier> modifiers = new LinkedHashMap<String, Modifier>(1);

        public Collection<Modifier> getModifiers() {
            return Collections.unmodifiableCollection(this.modifiers.values());
        }

        public void addModifier(Modifier modifier) {
            this.modifiers.put(modifier.getKey(), modifier);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.modifiers);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Modifiers that = (Modifiers)obj;
            return this.modifiers.equals(that.modifiers);
        }
    }

    public static enum Position {
        LAST,
        FIRST;

    }
}

