/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import org.springframework.data.keyvalue.core.mapping.AnnotationBasedKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.ClassNameKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class BasicKeyValuePersistentEntity<T, P extends KeyValuePersistentProperty<P>>
extends BasicPersistentEntity<T, P>
implements KeyValuePersistentEntity<T, P> {
    private static final KeySpaceResolver DEFAULT_FALLBACK_RESOLVER = ClassNameKeySpaceResolver.INSTANCE;
    private final String keyspace;

    public BasicKeyValuePersistentEntity(TypeInformation<T> information, KeySpaceResolver fallbackKeySpaceResolver) {
        super(information);
        this.keyspace = BasicKeyValuePersistentEntity.detectKeySpace(information.getType(), fallbackKeySpaceResolver);
    }

    private static String detectKeySpace(Class<?> type, KeySpaceResolver fallback) {
        String keySpace = AnnotationBasedKeySpaceResolver.INSTANCE.resolveKeySpace(type);
        if (StringUtils.hasText((String)keySpace)) {
            return keySpace;
        }
        return (fallback == null ? DEFAULT_FALLBACK_RESOLVER : fallback).resolveKeySpace(type);
    }

    @Override
    public String getKeySpace() {
        return this.keyspace;
    }
}

