/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SpelCriteria;
import org.springframework.data.keyvalue.core.SpelCriteriaAccessor;
import org.springframework.data.keyvalue.core.SpelSortAccessor;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

class SpelQueryEngine<T extends KeyValueAdapter>
extends QueryEngine<KeyValueAdapter, SpelCriteria, Comparator<?>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public SpelQueryEngine() {
        super(new SpelCriteriaAccessor(PARSER), new SpelSortAccessor(PARSER));
    }

    @Override
    public Collection<?> execute(SpelCriteria criteria, Comparator<?> sort, long offset, int rows, Serializable keyspace) {
        return this.sortAndFilterMatchingRange(this.getAdapter().getAllOf(keyspace), criteria, sort, offset, rows);
    }

    @Override
    public long count(SpelCriteria criteria, Serializable keyspace) {
        return SpelQueryEngine.filterMatchingRange(this.getAdapter().getAllOf(keyspace), criteria, -1L, -1).size();
    }

    private List<?> sortAndFilterMatchingRange(Iterable<?> source, SpelCriteria criteria, Comparator sort, long offset, int rows) {
        List<?> tmp = IterableConverter.toList(source);
        if (sort != null) {
            Collections.sort(tmp, sort);
        }
        return SpelQueryEngine.filterMatchingRange(tmp, criteria, offset, rows);
    }

    private static <S> List<S> filterMatchingRange(Iterable<S> source, SpelCriteria criteria, long offset, int rows) {
        ArrayList<S> result = new ArrayList<S>();
        boolean compareOffsetAndRows = 0L < offset || 0 <= rows;
        int remainingRows = rows;
        int curPos = 0;
        for (S candidate : source) {
            boolean matches;
            boolean bl = matches = criteria == null;
            if (!matches) {
                try {
                    matches = (Boolean)criteria.getExpression().getValue(criteria.getContext(), candidate, Boolean.class);
                }
                catch (SpelEvaluationException e) {
                    criteria.getContext().setVariable("it", candidate);
                    boolean bl2 = matches = criteria.getExpression().getValue(criteria.getContext()) == null ? false : (Boolean)criteria.getExpression().getValue(criteria.getContext(), Boolean.class);
                }
            }
            if (!matches) continue;
            if (compareOffsetAndRows) {
                if ((long)curPos >= offset && rows > 0) {
                    result.add(candidate);
                    if (--remainingRows <= 0) break;
                }
                ++curPos;
                continue;
            }
            result.add(candidate);
        }
        return result;
    }
}

