/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import java.util.function.Function;
import javax.persistence.TemporalType;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class QueryParameterSetterFactory {
    QueryParameterSetterFactory() {
    }

    abstract QueryParameterSetter create(StringQuery.ParameterBinding var1, String var2);

    public static QueryParameterSetterFactory basic(JpaParameters parameters) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        return new BasicQueryParameterSetterFactory(parameters);
    }

    public static QueryParameterSetterFactory forCriteriaQuery(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull(metadata, (String)"ParameterMetadata must not be null!");
        return new CriteriaQueryParameterSetterFactory(parameters, metadata);
    }

    public static QueryParameterSetterFactory parsing(SpelExpressionParser parser, EvaluationContextProvider evaluationContextProvider, Parameters<?, ?> parameters) {
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        return new ExpressionBasedQueryParameterSetterFactory(parser, evaluationContextProvider, parameters);
    }

    private static QueryParameterSetter createSetter(Function<Object[], Object> valueExtractor, StringQuery.ParameterBinding binding, JpaParameters.JpaParameter parameter, boolean lenient) {
        TemporalType temporalType = parameter != null && parameter.isTemporalParameter() ? parameter.getTemporalType() : null;
        return new QueryParameterSetter.NamedOrIndexedQueryParameterSetter(valueExtractor.andThen(binding::prepare), ParameterImpl.of(parameter, binding), temporalType, lenient);
    }

    private static class ParameterImpl<T>
    implements javax.persistence.Parameter<T> {
        private final Class<T> parameterType;
        private final String name;
        private final Integer position;

        static javax.persistence.Parameter<?> of(JpaParameters.JpaParameter parameter, StringQuery.ParameterBinding binding) {
            Class type = parameter == null ? Object.class : parameter.getType();
            return new ParameterImpl(type, ParameterImpl.getName(parameter, binding), binding.getPosition());
        }

        private ParameterImpl(Class<T> parameterType, String name, Integer position) {
            this.name = name;
            this.position = position;
            this.parameterType = parameterType;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Class<T> getParameterType() {
            return this.parameterType;
        }

        private static String getName(JpaParameters.JpaParameter parameter, StringQuery.ParameterBinding binding) {
            if (parameter == null) {
                return binding.getName();
            }
            return parameter.isNamedParameter() ? (String)parameter.getName().orElseThrow(() -> new IllegalArgumentException("o_O parameter needs to have a name!")) : null;
        }
    }

    private static class CriteriaQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final JpaParameters parameters;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

        CriteriaQueryParameterSetterFactory(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
            Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
            Assert.notNull(metadata, (String)"Expressions must not be null!");
            this.parameters = parameters;
            this.expressions = metadata;
        }

        @Override
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, String queryString) {
            ParameterMetadataProvider.ParameterMetadata<?> metadata = this.expressions.get(binding.getPosition() - 1);
            if (metadata.isIsNullParameter()) {
                return QueryParameterSetter.NOOP;
            }
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)this.parameters.getBindableParameter(binding.getPosition() - 1);
            TemporalType temporalType = parameter.isTemporalParameter() ? parameter.getTemporalType() : null;
            return new QueryParameterSetter.NamedOrIndexedQueryParameterSetter(values -> this.getAndPrepare(parameter, metadata, (Object[])values), (javax.persistence.Parameter<?>)metadata.getExpression(), temporalType, false);
        }

        private Object getAndPrepare(JpaParameters.JpaParameter parameter, ParameterMetadataProvider.ParameterMetadata<?> metadata, Object[] values) {
            JpaParametersParameterAccessor accessor = new JpaParametersParameterAccessor(this.parameters, values);
            return metadata.prepare(accessor.getValue(parameter));
        }
    }

    private static class BasicQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final JpaParameters parameters;

        BasicQueryParameterSetterFactory(JpaParameters parameters) {
            Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
            this.parameters = parameters;
        }

        @Override
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, String queryString) {
            JpaParameters.JpaParameter parameter = QueryUtils.hasNamedParameter(queryString) ? this.findParameterForBinding(binding) : (JpaParameters.JpaParameter)this.parameters.getBindableParameter(binding.getPosition() - 1);
            return parameter == null ? QueryParameterSetter.NOOP : QueryParameterSetterFactory.createSetter(values -> this.getValue((Object[])values, parameter), binding, parameter, false);
        }

        private JpaParameters.JpaParameter findParameterForBinding(StringQuery.ParameterBinding binding) {
            return ((JpaParameters)this.parameters.getBindableParameters()).stream().filter(candidate -> binding.getName().equals(BasicQueryParameterSetterFactory.getName(candidate))).findFirst().orElse(null);
        }

        private Object getValue(Object[] values, Parameter parameter) {
            return new JpaParametersParameterAccessor(this.parameters, values).getValue(parameter);
        }

        private static String getName(JpaParameters.JpaParameter p) {
            return (String)p.getName().orElseThrow(() -> new IllegalArgumentException("Parameter needs to be named!"));
        }
    }

    private static class ExpressionBasedQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final SpelExpressionParser parser;
        private final EvaluationContextProvider evaluationContextProvider;
        private final Parameters<?, ?> parameters;

        ExpressionBasedQueryParameterSetterFactory(SpelExpressionParser parser, EvaluationContextProvider evaluationContextProvider, Parameters<?, ?> parameters) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
            Assert.notNull(parameters, (String)"Parameters must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.parser = parser;
            this.parameters = parameters;
        }

        @Override
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, String queryString) {
            if (!binding.isExpression()) {
                return null;
            }
            Expression expression = this.parser.parseExpression(binding.getExpression());
            return QueryParameterSetterFactory.createSetter(values -> this.evaluateExpression(expression, (Object[])values), binding, null, true);
        }

        private Object evaluateExpression(Expression expression, Object[] values) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.parameters, values);
            return expression.getValue(context, Object.class);
        }
    }
}

