/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.util.Optional;
import org.springframework.data.annotation.Version;
import org.springframework.data.jpa.mapping.JpaPersistentEntity;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentEntityImpl<T>
extends BasicPersistentEntity<T, JpaPersistentProperty>
implements JpaPersistentEntity<T> {
    private static final String INVALID_VERSION_ANNOTATION = "%s is annotated with " + Version.class.getName() + " but needs to use " + javax.persistence.Version.class.getName() + " to trigger optimistic locking correctly!";
    private final ProxyIdAccessor proxyIdAccessor;

    public JpaPersistentEntityImpl(TypeInformation<T> information, ProxyIdAccessor proxyIdAccessor) {
        super(information, Optional.empty());
        Assert.notNull((Object)proxyIdAccessor, (String)"ProxyIdAccessor must not be null!");
        this.proxyIdAccessor = proxyIdAccessor;
    }

    protected JpaPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(JpaPersistentProperty property) {
        return property.isIdProperty() ? property : null;
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return new JpaProxyAwareIdentifierAccessor(this, bean, this.proxyIdAccessor);
    }

    public void verify() {
        super.verify();
        Optional versionProperty = this.getVersionProperty();
        if (!versionProperty.isPresent()) {
            return;
        }
        if (((JpaPersistentProperty)versionProperty.get()).isAnnotationPresent(Version.class)) {
            throw new IllegalArgumentException(String.format(INVALID_VERSION_ANNOTATION, versionProperty));
        }
    }

    private static class JpaProxyAwareIdentifierAccessor
    extends IdPropertyIdentifierAccessor {
        private final Object bean;
        private final ProxyIdAccessor proxyIdAccessor;

        public JpaProxyAwareIdentifierAccessor(JpaPersistentEntity<?> entity, Object bean, ProxyIdAccessor proxyIdAccessor) {
            super(entity, bean);
            Assert.notNull((Object)proxyIdAccessor, (String)"Proxy identifier accessor must not be null!");
            this.proxyIdAccessor = proxyIdAccessor;
            this.bean = bean;
        }

        public Optional<Object> getIdentifier() {
            return this.proxyIdAccessor.shouldUseAccessorFor(this.bean) ? Optional.ofNullable(this.proxyIdAccessor.getIdentifierFrom(this.bean)) : super.getIdentifier();
        }
    }
}

