/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import javax.persistence.Access;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.persistence.metamodel.Metamodel;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<JpaPersistentProperty>
implements JpaPersistentProperty {
    private static final Collection<Class<? extends Annotation>> ASSOCIATION_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> ID_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> UPDATEABLE_ANNOTATIONS;
    private final Optional<Boolean> usePropertyAccess;
    private final Optional<TypeInformation<?>> associationTargetType;
    private final boolean updateable;
    private final JpaMetamodel metamodel;

    public JpaPersistentPropertyImpl(Metamodel metamodel, Property property, PersistentEntity<?, JpaPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        this.usePropertyAccess = this.detectPropertyAccess();
        this.associationTargetType = this.detectAssociationTargetType();
        this.updateable = this.detectUpdatability();
        this.metamodel = new JpaMetamodel(metamodel);
    }

    public Class<?> getActualType() {
        return this.associationTargetType.isPresent() ? this.associationTargetType.get().getType() : super.getActualType();
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        return this.associationTargetType.isPresent() ? Collections.singleton(this.associationTargetType.get()) : super.getPersistentEntityType();
    }

    public boolean isIdProperty() {
        return ID_ANNOTATIONS.stream().anyMatch(it -> this.isAnnotationPresent((Class)it));
    }

    public boolean isEntity() {
        return this.metamodel.isJpaManaged(this.getActualType());
    }

    public boolean isAssociation() {
        if (ASSOCIATION_ANNOTATIONS.stream().anyMatch(it -> this.findAnnotation((Class)it).isPresent())) {
            return true;
        }
        return this.getType().isAnnotationPresent(Embeddable.class);
    }

    public boolean isTransient() {
        return this.isAnnotationPresent(Transient.class) || super.isTransient();
    }

    protected Association<JpaPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean usePropertyAccess() {
        return this.usePropertyAccess.orElseGet(() -> super.usePropertyAccess());
    }

    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    public boolean isWritable() {
        return this.updateable && super.isWritable();
    }

    private Optional<Boolean> detectPropertyAccess() {
        Optional accessType = this.findAnnotation(AccessType.class);
        if (accessType.isPresent()) {
            return accessType.map(it -> AccessType.Type.PROPERTY.equals((Object)it.value()));
        }
        Optional access = this.findAnnotation(Access.class);
        if (access.isPresent()) {
            return access.map(it -> javax.persistence.AccessType.PROPERTY.equals((Object)it.value()));
        }
        accessType = this.findPropertyOrOwnerAnnotation(AccessType.class);
        if (accessType.isPresent()) {
            return accessType.map(it -> AccessType.Type.PROPERTY.equals((Object)it.value()));
        }
        access = this.findPropertyOrOwnerAnnotation(Access.class);
        return access.map(t -> javax.persistence.AccessType.PROPERTY.equals((Object)t.value()));
    }

    private Optional<TypeInformation<?>> detectAssociationTargetType() {
        if (!this.isAssociation()) {
            return Optional.empty();
        }
        return ASSOCIATION_ANNOTATIONS.stream().flatMap(it -> Optionals.toStream((Optional[])new Optional[]{this.findAnnotation((Class)it)})).map(it -> AnnotationUtils.getValue((Annotation)it, (String)"targetEntity")).filter(it -> it != null && !Void.TYPE.equals(it)).map(it -> (Class)it).findFirst().map(it -> ClassTypeInformation.from((Class)it));
    }

    private final boolean detectUpdatability() {
        return !UPDATEABLE_ANNOTATIONS.stream().flatMap(it -> Optionals.toStream((Optional[])new Optional[]{this.findAnnotation((Class)it)})).map(it -> AnnotationUtils.getValue((Annotation)it, (String)"updatable")).anyMatch(it -> it.equals(Boolean.FALSE));
    }

    static {
        HashSet<Class<OrderColumn>> annotations = new HashSet<Class<OrderColumn>>();
        annotations.add(OneToMany.class);
        annotations.add(OneToOne.class);
        annotations.add(ManyToMany.class);
        annotations.add(ManyToOne.class);
        annotations.add(Embedded.class);
        ASSOCIATION_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Id.class);
        annotations.add(EmbeddedId.class);
        ID_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Column.class);
        annotations.add(OrderColumn.class);
        UPDATEABLE_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }
}

