/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableEmbeddedManager;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;

public class EmbeddedManagerConfiguration
extends EmbeddedServiceConfigurationSupport {
    @Override
    protected Class getAnnotationType() {
        return EnableEmbeddedManager.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        Properties gemfireProperties = new Properties();
        boolean jmxManager = Boolean.valueOf(String.valueOf(annotationAttributes.get("jmxManager")));
        if (jmxManager) {
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager", Boolean.TRUE.toString());
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-access-file", annotationAttributes.get("jmxManagerAccessFile"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-bind-address", annotationAttributes.get("jmxManagerBindAddress"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-hostname-for-clients", annotationAttributes.get("jmxManagerHostnameForClients"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-password-file", annotationAttributes.get("jmxManagerPasswordFile"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-port", annotationAttributes.get("jmxManagerPort"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-start", annotationAttributes.get("jmxManagerStart"));
            EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-update-rate", annotationAttributes.get("jmxManagerUpdateRate"));
            boolean jmxManagerSslEnabled = Boolean.valueOf(String.valueOf(annotationAttributes.get("jmxManagerSslEnabled")));
            if (jmxManagerSslEnabled) {
                EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-ssl-enabled", Boolean.TRUE.toString());
                EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-ssl-ciphers", annotationAttributes.get("jmxManagerSslCiphers"));
                EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-ssl-protocols", annotationAttributes.get("jmxManagerSslProtocols"));
                EmbeddedManagerConfiguration.setProperty(gemfireProperties, "jmx-manager-ssl-require-authentication", annotationAttributes.get("jmxManagerSslRequireAuthentication"));
            }
        }
        return gemfireProperties;
    }
}

