/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.support.ConnectionEndpoint;

@Configuration
public class ClientCacheConfiguration
extends AbstractCacheConfiguration {
    protected static final boolean DEFAULT_READY_FOR_EVENTS = false;
    protected static final String DEFAULT_NAME = "SpringBasedCacheClientApplication";
    private boolean readyForEvents = false;
    private Boolean keepAlive;
    private Boolean multiUserAuthentication;
    private Boolean prSingleHopEnabled;
    private Boolean subscriptionEnabled;
    private Boolean threadLocalConnections;
    private Integer durableClientTimeout;
    private Integer freeConnectionTimeout;
    private Integer loadConditioningInterval;
    private Integer maxConnections;
    private Integer minConnections;
    private Integer readTimeout;
    private Integer retryAttempts;
    private Integer socketBufferSize;
    private Integer statisticsInterval;
    private Integer subscriptionAckInterval;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private Iterable<ConnectionEndpoint> locators;
    private Iterable<ConnectionEndpoint> servers;
    private Long idleTimeout;
    private Long pingInterval;
    private String durableClientId;
    private String serverGroup;

    @Bean
    public ClientCacheFactoryBean gemfireCache() {
        ClientCacheFactoryBean gemfireCache = (ClientCacheFactoryBean)this.constructCacheFactoryBean();
        gemfireCache.setDurableClientId(this.durableClientId());
        gemfireCache.setDurableClientTimeout(this.durableClientTimeout());
        gemfireCache.setFreeConnectionTimeout(this.freeConnectionTimeout());
        gemfireCache.setIdleTimeout(this.idleTimeout());
        gemfireCache.setKeepAlive(this.keepAlive());
        gemfireCache.setLocators(this.poolLocators());
        gemfireCache.setLoadConditioningInterval(this.loadConditioningInterval());
        gemfireCache.setMaxConnections(this.maxConnections());
        gemfireCache.setMinConnections(this.minConnections());
        gemfireCache.setMultiUserAuthentication(this.multiUserAuthentication());
        gemfireCache.setPingInterval(this.pingInterval());
        gemfireCache.setPrSingleHopEnabled(this.prSingleHopEnabled());
        gemfireCache.setReadTimeout(this.readTimeout());
        gemfireCache.setReadyForEvents(this.readyForEvents());
        gemfireCache.setRetryAttempts(this.retryAttempts());
        gemfireCache.setServerGroup(this.serverGroup());
        gemfireCache.setServers(this.poolServers());
        gemfireCache.setSocketBufferSize(this.socketBufferSize());
        gemfireCache.setStatisticsInterval(this.statisticsInterval());
        gemfireCache.setSubscriptionAckInterval(this.subscriptionAckInterval());
        gemfireCache.setSubscriptionEnabled(this.subscriptionEnabled());
        gemfireCache.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout());
        gemfireCache.setSubscriptionRedundancy(this.subscriptionRedundancy());
        gemfireCache.setThreadLocalConnections(this.threadLocalConnections());
        return gemfireCache;
    }

    @Override
    protected <T extends CacheFactoryBean> T newCacheFactoryBean() {
        return (T)new ClientCacheFactoryBean();
    }

    @Override
    protected void configureCache(AnnotationMetadata importMetadata) {
        super.configureCache(importMetadata);
        if (this.isClientCacheApplication(importMetadata)) {
            Map clientCacheApplicationAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setDurableClientId((String)clientCacheApplicationAttributes.get("durableClientId"));
            this.setDurableClientTimeout((Integer)clientCacheApplicationAttributes.get("durableClientTimeout"));
            this.setFreeConnectionTimeout((Integer)clientCacheApplicationAttributes.get("freeConnectionTimeout"));
            this.setIdleTimeout((Long)clientCacheApplicationAttributes.get("idleTimeout"));
            this.setKeepAlive(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("keepAlive")));
            this.setLoadConditioningInterval((Integer)clientCacheApplicationAttributes.get("loadConditionInterval"));
            this.setMaxConnections((Integer)clientCacheApplicationAttributes.get("maxConnections"));
            this.setMinConnections((Integer)clientCacheApplicationAttributes.get("minConnections"));
            this.setMultiUserAuthentication(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("multiUserAuthentication")));
            this.setPingInterval((Long)clientCacheApplicationAttributes.get("pingInterval"));
            this.setPrSingleHopEnabled(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("prSingleHopEnabled")));
            this.setReadTimeout((Integer)clientCacheApplicationAttributes.get("readTimeout"));
            this.setReadyForEvents(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("readyForEvents")));
            this.setRetryAttempts((Integer)clientCacheApplicationAttributes.get("retryAttempts"));
            this.setServerGroup((String)clientCacheApplicationAttributes.get("serverGroup"));
            this.setSocketBufferSize((Integer)clientCacheApplicationAttributes.get("socketBufferSize"));
            this.setStatisticsInterval((Integer)clientCacheApplicationAttributes.get("statisticInterval"));
            this.setSubscriptionAckInterval((Integer)clientCacheApplicationAttributes.get("subscriptionAckInterval"));
            this.setSubscriptionEnabled(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("subscriptionEnabled")));
            this.setSubscriptionMessageTrackingTimeout((Integer)clientCacheApplicationAttributes.get("subscriptionMessageTrackingTimeout"));
            this.setSubscriptionRedundancy((Integer)clientCacheApplicationAttributes.get("subscriptionRedundancy"));
            this.setThreadLocalConnections(Boolean.TRUE.equals(clientCacheApplicationAttributes.get("threadLocalConnections")));
            this.configureLocatorOrServer(clientCacheApplicationAttributes);
        }
    }

    void configureLocatorOrServer(Map<String, Object> clientCacheApplicationAttributes) {
        AnnotationAttributes[] locators = (AnnotationAttributes[])clientCacheApplicationAttributes.get("locators");
        ArrayList<ConnectionEndpoint> poolLocators = new ArrayList<ConnectionEndpoint>(locators.length);
        for (AnnotationAttributes locator : locators) {
            poolLocators.add(new ConnectionEndpoint((String)locator.get((Object)"host"), (Integer)locator.get((Object)"port")));
        }
        this.setPoolLocators(poolLocators);
        AnnotationAttributes[] servers = (AnnotationAttributes[])clientCacheApplicationAttributes.get("servers");
        ArrayList<ConnectionEndpoint> poolServers = new ArrayList<ConnectionEndpoint>(servers.length);
        for (AnnotationAttributes server : servers) {
            poolServers.add(new ConnectionEndpoint((String)server.get((Object)"host"), (Integer)server.get((Object)"port")));
        }
        this.setPoolServers(poolServers);
    }

    @Override
    protected Class getAnnotationType() {
        return ClientCacheApplication.class;
    }

    void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    protected String durableClientId() {
        return this.durableClientId;
    }

    void setDurableClientTimeout(Integer durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    protected Integer durableClientTimeout() {
        return this.durableClientTimeout;
    }

    void setFreeConnectionTimeout(Integer freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    protected Integer freeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected Long idleTimeout() {
        return this.idleTimeout;
    }

    void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected Boolean keepAlive() {
        return this.keepAlive;
    }

    void setLoadConditioningInterval(Integer loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    protected Integer loadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected Integer maxConnections() {
        return this.maxConnections;
    }

    void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    protected Integer minConnections() {
        return this.minConnections;
    }

    void setMultiUserAuthentication(Boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    protected Boolean multiUserAuthentication() {
        return this.multiUserAuthentication;
    }

    void setPingInterval(Long pingInterval) {
        this.pingInterval = pingInterval;
    }

    protected Long pingInterval() {
        return this.pingInterval;
    }

    void setPoolLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators = locators;
    }

    protected Iterable<ConnectionEndpoint> poolLocators() {
        return this.locators;
    }

    void setPoolServers(Iterable<ConnectionEndpoint> servers) {
        this.servers = servers;
    }

    protected Iterable<ConnectionEndpoint> poolServers() {
        return this.servers;
    }

    void setPrSingleHopEnabled(Boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    protected Boolean prSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected Integer readTimeout() {
        return this.readTimeout;
    }

    void setReadyForEvents(boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    protected boolean readyForEvents() {
        return this.readyForEvents;
    }

    void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    protected Integer retryAttempts() {
        return this.retryAttempts;
    }

    void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    protected String serverGroup() {
        return this.serverGroup;
    }

    void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    protected Integer socketBufferSize() {
        return this.socketBufferSize;
    }

    void setStatisticsInterval(Integer statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    protected Integer statisticsInterval() {
        return this.statisticsInterval;
    }

    void setSubscriptionAckInterval(Integer subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    protected Integer subscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    protected Boolean subscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    void setSubscriptionMessageTrackingTimeout(Integer subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    protected Integer subscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    void setSubscriptionRedundancy(Integer subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    protected Integer subscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    void setThreadLocalConnections(Boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    protected Boolean threadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

